/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

public class SwitchLike {
    private final UastNode node;
    private final List<UastNode> caseNodes;

    public SwitchLike(UastNode node, List<UastNode> caseNodes) {
        this.node = node;
        this.caseNodes = caseNodes;
    }

    @Nullable
    public static SwitchLike from(UastNode node) {
        if (!node.is(UastNode.Kind.SWITCH)) {
            return null;
        }
        return new SwitchLike(node, SwitchLike.getCases(node));
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode switchKeyword() {
        return this.node.getChild(UastNode.Kind.KEYWORD).orElse(this.node);
    }

    public List<UastNode> caseNodes() {
        return this.caseNodes;
    }

    private static List<UastNode> getCases(UastNode switchNode) {
        ArrayList<UastNode> results = new ArrayList<UastNode>();
        switchNode.children.forEach(child -> child.getDescendants(UastNode.Kind.CASE, results::add, UastNode.Kind.SWITCH));
        return results;
    }
}

