/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ContinuousQueryAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.querycache.subscriber.ListenerInfo;
import com.hazelcast.client.impl.querycache.subscriber.QueryCacheToListenerMapper;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EventLostEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.event.EventData;
import com.hazelcast.map.impl.querycache.ListenerRegistrationHelper;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.event.BatchEventData;
import com.hazelcast.map.impl.querycache.event.BatchIMapEvent;
import com.hazelcast.map.impl.querycache.event.LocalEntryEventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.SingleIMapEvent;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEventListenerAdapters;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.executor.StripedExecutor;
import com.hazelcast.util.executor.StripedRunnable;
import com.hazelcast.util.executor.TimeoutRunnable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class ClientQueryCacheEventService
implements QueryCacheEventService {
    private static final int EVENT_QUEUE_TIMEOUT_MILLIS = 500;
    private static final ConstructorFunction<String, QueryCacheToListenerMapper> REGISTRY_CONSTRUCTOR = new ConstructorFunction<String, QueryCacheToListenerMapper>(){

        public QueryCacheToListenerMapper createNew(String arg) {
            return new QueryCacheToListenerMapper();
        }
    };
    private final StripedExecutor executor;
    private final ClientListenerService listenerService;
    private final InternalSerializationService serializationService;
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final ConcurrentMap<String, QueryCacheToListenerMapper> registrations;

    public ClientQueryCacheEventService(HazelcastClientInstanceImpl client) {
        AbstractClientListenerService listenerService = (AbstractClientListenerService)client.getListenerService();
        this.listenerService = listenerService;
        this.serializationService = client.getSerializationService();
        this.executor = listenerService.getEventExecutor();
        this.registrations = new ConcurrentHashMap<String, QueryCacheToListenerMapper>();
    }

    public boolean hasListener(String mapName, String cacheId) {
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMapper == null) {
            return false;
        }
        return queryCacheToListenerMapper.hasListener(cacheId);
    }

    public ConcurrentMap<String, QueryCacheToListenerMapper> getRegistrations() {
        return this.registrations;
    }

    public void sendEventToSubscriber(String name, Object eventData, int orderKey) {
        throw new UnsupportedOperationException();
    }

    public void publish(String mapName, String cacheId, Object event, int orderKey, Extractors extractors) {
        Preconditions.checkHasText((String)mapName, (String)"mapName");
        Preconditions.checkHasText((String)cacheId, (String)"cacheId");
        Preconditions.checkNotNull((Object)event, (String)"event cannot be null");
        Collection<ListenerInfo> listeners = this.getListeners(mapName, cacheId);
        for (ListenerInfo info : listeners) {
            if (!this.canPassFilter(event, info.getFilter(), extractors)) continue;
            try {
                this.executor.execute((Runnable)((Object)new EventDispatcher(event, info, orderKey, (SerializationService)this.serializationService, 500L)));
            }
            catch (RejectedExecutionException e) {
                this.logger.warning("EventQueue overloaded! Can not process IMap=[" + mapName + "], QueryCache=[ " + cacheId + "], Event=[" + event + "]");
            }
        }
    }

    private boolean canPassFilter(Object eventData, EventFilter filter, Extractors extractors) {
        if (filter == null || filter instanceof TrueEventFilter) {
            return true;
        }
        if (!(eventData instanceof LocalEntryEventData)) {
            return true;
        }
        LocalEntryEventData localEntryEventData = (LocalEntryEventData)eventData;
        if (localEntryEventData.getEventType() != EventLostEvent.EVENT_TYPE) {
            Object value = this.getValueOrOldValue(localEntryEventData);
            Data keyData = localEntryEventData.getKeyData();
            QueryEntry entry = new QueryEntry(this.serializationService, keyData, value, extractors);
            return filter.eval((Object)entry);
        }
        return true;
    }

    private Object getValueOrOldValue(LocalEntryEventData localEntryEventData) {
        Object value = localEntryEventData.getValue();
        return value != null ? value : localEntryEventData.getOldValue();
    }

    public String addPublisherListener(String mapName, String cacheId, ListenerAdapter adapter) {
        String listenerName = ListenerRegistrationHelper.generateListenerName((String)mapName, (String)cacheId);
        QueryCacheHandler handler = new QueryCacheHandler(adapter);
        return this.listenerService.registerListener(this.createPublisherListenerCodec(listenerName), handler);
    }

    public boolean removePublisherListener(String mapName, String cacheId, String listenerId) {
        return this.listenerService.deregisterListener(listenerId);
    }

    private ListenerMessageCodec createPublisherListenerCodec(final String listenerName) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ContinuousQueryAddListenerCodec.encodeRequest((String)listenerName, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ContinuousQueryAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)listenerName, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public String addListener(String mapName, String cacheId, MapListener listener) {
        return this.addListener(mapName, cacheId, listener, null);
    }

    public String addListener(String mapName, String cacheId, MapListener listener, EventFilter filter) {
        Preconditions.checkHasText((String)mapName, (String)"mapName");
        Preconditions.checkHasText((String)cacheId, (String)"cacheId");
        Preconditions.checkNotNull((Object)listener, (String)"listener cannot be null");
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)ConcurrencyUtil.getOrPutIfAbsent(this.registrations, (Object)mapName, REGISTRY_CONSTRUCTOR);
        ListenerAdapter listenerAdaptor = QueryCacheEventListenerAdapters.createQueryCacheListenerAdaptor((MapListener)listener);
        return queryCacheToListenerMapper.addListener(cacheId, listenerAdaptor, filter);
    }

    public boolean removeListener(String mapName, String cacheId, String listenerId) {
        Preconditions.checkHasText((String)mapName, (String)"mapName");
        Preconditions.checkHasText((String)cacheId, (String)"cacheId");
        Preconditions.checkHasText((String)listenerId, (String)"listenerId");
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)ConcurrencyUtil.getOrPutIfAbsent(this.registrations, (Object)mapName, REGISTRY_CONSTRUCTOR);
        return queryCacheToListenerMapper.removeListener(cacheId, listenerId);
    }

    public void removeAllListeners(String mapName, String cacheId) {
        Preconditions.checkHasText((String)mapName, (String)"mapName");
        Preconditions.checkHasText((String)cacheId, (String)"cacheId");
        QueryCacheToListenerMapper queryCacheToListenerMap = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMap != null) {
            queryCacheToListenerMap.removeAllListeners(cacheId);
        }
    }

    private Collection<ListenerInfo> getListeners(String mapName, String cacheName) {
        QueryCacheToListenerMapper queryCacheToListenerMapper = (QueryCacheToListenerMapper)this.registrations.get(mapName);
        if (queryCacheToListenerMapper == null) {
            return Collections.emptySet();
        }
        return queryCacheToListenerMapper.getListenerInfos(cacheName);
    }

    private static class EventDispatcher
    implements StripedRunnable,
    TimeoutRunnable {
        private final Object event;
        private final ListenerInfo listenerInfo;
        private final int orderKey;
        private final long timeoutMs;
        private final SerializationService serializationService;

        public EventDispatcher(Object event, ListenerInfo listenerInfo, int orderKey, SerializationService serializationService, long timeoutMs) {
            this.event = event;
            this.listenerInfo = listenerInfo;
            this.orderKey = orderKey;
            this.timeoutMs = timeoutMs;
            this.serializationService = serializationService;
        }

        public int getKey() {
            return this.orderKey;
        }

        public void run() {
            EventData eventData = (EventData)this.event;
            EventFilter filter = this.listenerInfo.getFilter();
            IMapEvent event = EventPublisherHelper.createIMapEvent((EventData)eventData, (EventFilter)filter, null, (SerializationService)this.serializationService);
            ListenerAdapter listenerAdapter = this.listenerInfo.getListenerAdapter();
            listenerAdapter.onEvent((Object)event);
        }

        public long getTimeout() {
            return this.timeoutMs;
        }

        public TimeUnit getTimeUnit() {
            return TimeUnit.MILLISECONDS;
        }
    }

    private final class QueryCacheHandler
    extends ContinuousQueryAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter adapter;

        private QueryCacheHandler(ListenerAdapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handleQueryCacheSingleEventV10(QueryCacheEventData data) {
            this.adapter.onEvent((Object)new SingleIMapEvent(data));
        }

        public void handleQueryCacheBatchEventV10(Collection<QueryCacheEventData> events, String source, int partitionId) {
            this.adapter.onEvent((Object)new BatchIMapEvent(new BatchEventData(events, source, partitionId)));
        }
    }
}

