/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import com.google.common.net.HostAndPort;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.application.AppState;
import org.sonar.application.AppStateImpl;
import org.sonar.application.cluster.AppNodesClusterHostsConsistency;
import org.sonar.application.cluster.ClusterAppStateImpl;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.ClusterSettings;
import org.sonar.application.es.EsConnector;
import org.sonar.application.es.EsConnectorImpl;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.cluster.hz.HazelcastMember;
import org.sonar.process.cluster.hz.HazelcastMemberBuilder;

public class AppStateFactory {
    private final AppSettings settings;

    public AppStateFactory(AppSettings settings) {
        this.settings = settings;
    }

    public AppState create() {
        if (ClusterSettings.shouldStartHazelcast(this.settings)) {
            EsConnector esConnector = AppStateFactory.createEsConnector(this.settings.getProps());
            HazelcastMember hzMember = AppStateFactory.createHzMember(this.settings.getProps());
            AppNodesClusterHostsConsistency appNodesClusterHostsConsistency = AppNodesClusterHostsConsistency.setInstance(hzMember, this.settings);
            return new ClusterAppStateImpl(this.settings, hzMember, esConnector, appNodesClusterHostsConsistency);
        }
        return new AppStateImpl();
    }

    private static HazelcastMember createHzMember(Props props) {
        HazelcastMemberBuilder builder = new HazelcastMemberBuilder().setNetworkInterface(props.nonNullValue(ProcessProperties.Property.CLUSTER_NODE_HOST.getKey())).setMembers(Arrays.asList(props.nonNullValue(ProcessProperties.Property.CLUSTER_HZ_HOSTS.getKey()).split(","))).setNodeName(props.nonNullValue(ProcessProperties.Property.CLUSTER_NODE_NAME.getKey())).setPort(Integer.parseInt(props.nonNullValue(ProcessProperties.Property.CLUSTER_NODE_HZ_PORT.getKey()))).setProcessId(ProcessId.APP);
        return builder.build();
    }

    private static EsConnector createEsConnector(Props props) {
        String searchHosts = props.nonNullValue(ProcessProperties.Property.CLUSTER_SEARCH_HOSTS.getKey());
        Set<HostAndPort> hostAndPorts = Arrays.stream(searchHosts.split(",")).map(HostAndPort::fromString).collect(Collectors.toSet());
        return new EsConnectorImpl(props.nonNullValue(ProcessProperties.Property.CLUSTER_NAME.getKey()), hostAndPorts);
    }
}

