/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application.command;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import org.slf4j.LoggerFactory;
import org.sonar.application.command.AbstractCommand;
import org.sonar.application.command.CeJvmOptions;
import org.sonar.application.command.CommandFactory;
import org.sonar.application.command.EsJvmOptions;
import org.sonar.application.command.EsScriptCommand;
import org.sonar.application.command.JavaCommand;
import org.sonar.application.command.JavaVersion;
import org.sonar.application.command.JvmOptions;
import org.sonar.application.command.WebJvmOptions;
import org.sonar.application.es.EsInstallation;
import org.sonar.application.es.EsLogging;
import org.sonar.application.es.EsSettings;
import org.sonar.application.es.EsYmlSettings;
import org.sonar.process.ProcessId;
import org.sonar.process.ProcessProperties;
import org.sonar.process.Props;
import org.sonar.process.System2;

public class CommandFactoryImpl
implements CommandFactory {
    private static final String ENV_VAR_JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    private static final String ENV_VAR_ES_JAVA_OPTS = "ES_JAVA_OPTS";
    private static final String[] PROXY_PROPERTY_KEYS = new String[]{ProcessProperties.Property.HTTP_PROXY_HOST.getKey(), ProcessProperties.Property.HTTP_PROXY_PORT.getKey(), ProcessProperties.Property.HTTP_NON_PROXY_HOSTS.getKey(), ProcessProperties.Property.HTTPS_PROXY_HOST.getKey(), ProcessProperties.Property.HTTPS_PROXY_PORT.getKey(), ProcessProperties.Property.HTTP_AUTH_NLM_DOMAN.getKey(), ProcessProperties.Property.SOCKS_PROXY_HOST.getKey(), ProcessProperties.Property.SOCKS_PROXY_PORT.getKey()};
    private final Props props;
    private final File tempDir;
    private final System2 system2;
    private final JavaVersion javaVersion;

    public CommandFactoryImpl(Props props, File tempDir, System2 system2, JavaVersion javaVersion) {
        String esJavaOpts;
        this.props = props;
        this.tempDir = tempDir;
        this.system2 = system2;
        this.javaVersion = javaVersion;
        String javaToolOptions = system2.getenv(ENV_VAR_JAVA_TOOL_OPTIONS);
        if (javaToolOptions != null && !javaToolOptions.trim().isEmpty()) {
            LoggerFactory.getLogger(CommandFactoryImpl.class).warn("JAVA_TOOL_OPTIONS is defined but will be ignored. Use properties sonar.*.javaOpts and/or sonar.*.javaAdditionalOpts in sonar.properties to change SQ JVM processes options");
        }
        if ((esJavaOpts = system2.getenv(ENV_VAR_ES_JAVA_OPTS)) != null && !esJavaOpts.trim().isEmpty()) {
            LoggerFactory.getLogger(CommandFactoryImpl.class).warn("ES_JAVA_OPTS is defined but will be ignored. Use properties sonar.search.javaOpts and/or sonar.search.javaAdditionalOpts in sonar.properties to change SQ JVM processes options");
        }
    }

    @Override
    public AbstractCommand<?> createEsCommand() {
        if (this.system2.isOsWindows()) {
            return this.createEsCommandForWindows();
        }
        return this.createEsCommandForUnix();
    }

    private EsScriptCommand createEsCommandForUnix() {
        EsInstallation esInstallation = this.createEsInstallation();
        return (EsScriptCommand)((EsScriptCommand)((EsScriptCommand)((EsScriptCommand)((EsScriptCommand)((EsScriptCommand)new EsScriptCommand(ProcessId.ELASTICSEARCH, esInstallation.getHomeDirectory()).setEsInstallation(esInstallation)).setEnvVariable("ES_PATH_CONF", esInstallation.getConfDirectory().getAbsolutePath())).setEnvVariable("ES_JVM_OPTIONS", esInstallation.getJvmOptions().getAbsolutePath())).setEnvVariable("JAVA_HOME", System.getProperties().getProperty("java.home"))).suppressEnvVariable(ENV_VAR_JAVA_TOOL_OPTIONS)).suppressEnvVariable(ENV_VAR_ES_JAVA_OPTS);
    }

    private JavaCommand createEsCommandForWindows() {
        EsInstallation esInstallation = this.createEsInstallation();
        return (JavaCommand)((JavaCommand)((JavaCommand)((JavaCommand)((JavaCommand)new JavaCommand(ProcessId.ELASTICSEARCH, esInstallation.getHomeDirectory()).setEsInstallation(esInstallation)).setReadsArgumentsFromFile(false).setJvmOptions(((EsJvmOptions)((EsJvmOptions)esInstallation.getEsJvmOptions().add("-Delasticsearch")).add("-Des.path.home=" + esInstallation.getHomeDirectory().getAbsolutePath())).add("-Des.path.conf=" + esInstallation.getConfDirectory().getAbsolutePath())).setEnvVariable("ES_JVM_OPTIONS", esInstallation.getJvmOptions().getAbsolutePath())).setEnvVariable("JAVA_HOME", System.getProperties().getProperty("java.home"))).setClassName("org.elasticsearch.bootstrap.Elasticsearch").addClasspath("lib/*").suppressEnvVariable(ENV_VAR_JAVA_TOOL_OPTIONS)).suppressEnvVariable(ENV_VAR_ES_JAVA_OPTS);
    }

    private EsInstallation createEsInstallation() {
        EsInstallation esInstallation = new EsInstallation(this.props);
        if (!esInstallation.getExecutable().exists()) {
            throw new IllegalStateException("Cannot find elasticsearch binary");
        }
        Map<String, String> settingsMap = new EsSettings(this.props, esInstallation, System2.INSTANCE).build();
        esInstallation.setLog4j2Properties(new EsLogging().createProperties(this.props, esInstallation.getLogDirectory())).setEsJvmOptions((EsJvmOptions)((EsJvmOptions)new EsJvmOptions(this.props, this.tempDir).addFromMandatoryProperty(this.props, ProcessProperties.Property.SEARCH_JAVA_OPTS.getKey())).addFromMandatoryProperty(this.props, ProcessProperties.Property.SEARCH_JAVA_ADDITIONAL_OPTS.getKey())).setEsYmlSettings(new EsYmlSettings(settingsMap)).setClusterName(settingsMap.get("cluster.name")).setHost(settingsMap.get("network.host")).setPort(Integer.valueOf(settingsMap.get("transport.tcp.port")));
        return esInstallation;
    }

    @Override
    public JavaCommand createWebCommand(boolean leader) {
        File homeDir = this.props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
        WebJvmOptions jvmOptions = (WebJvmOptions)((WebJvmOptions)new WebJvmOptions(this.tempDir, this.javaVersion).addFromMandatoryProperty(this.props, ProcessProperties.Property.WEB_JAVA_OPTS.getKey())).addFromMandatoryProperty(this.props, ProcessProperties.Property.WEB_JAVA_ADDITIONAL_OPTS.getKey());
        this.addProxyJvmOptions(jvmOptions);
        JavaCommand command = ((JavaCommand)new JavaCommand(ProcessId.WEB_SERVER, homeDir).setReadsArgumentsFromFile(true).setArguments(this.props.rawProperties()).setJvmOptions(jvmOptions).setGracefulStopTimeoutMs(CommandFactoryImpl.getGracefulStopTimeoutMs(this.props, ProcessProperties.Property.WEB_GRACEFUL_STOP_TIMEOUT)).setEnvVariable(ProcessProperties.Property.PATH_LOGS.getKey(), this.props.nonNullValue(ProcessProperties.Property.PATH_LOGS.getKey()))).setArgument("sonar.cluster.web.startupLeader", Boolean.toString(leader)).setClassName("org.sonar.server.app.WebServer").addClasspath("./lib/common/*");
        String driverPath = this.props.value(ProcessProperties.Property.JDBC_DRIVER_PATH.getKey());
        if (driverPath != null) {
            command.addClasspath(driverPath);
        }
        command.suppressEnvVariable(ENV_VAR_JAVA_TOOL_OPTIONS);
        return command;
    }

    @Override
    public JavaCommand createCeCommand() {
        File homeDir = this.props.nonNullValueAsFile(ProcessProperties.Property.PATH_HOME.getKey());
        CeJvmOptions jvmOptions = (CeJvmOptions)((CeJvmOptions)new CeJvmOptions(this.tempDir, this.javaVersion).addFromMandatoryProperty(this.props, ProcessProperties.Property.CE_JAVA_OPTS.getKey())).addFromMandatoryProperty(this.props, ProcessProperties.Property.CE_JAVA_ADDITIONAL_OPTS.getKey());
        this.addProxyJvmOptions(jvmOptions);
        JavaCommand<CeJvmOptions> command = new JavaCommand(ProcessId.COMPUTE_ENGINE, homeDir).setReadsArgumentsFromFile(true).setArguments(this.props.rawProperties()).setJvmOptions(jvmOptions).setGracefulStopTimeoutMs(CommandFactoryImpl.getGracefulStopTimeoutMs(this.props, ProcessProperties.Property.CE_GRACEFUL_STOP_TIMEOUT)).setClassName("org.sonar.ce.app.CeServer").addClasspath("./lib/common/*");
        String driverPath = this.props.value(ProcessProperties.Property.JDBC_DRIVER_PATH.getKey());
        if (driverPath != null) {
            command.addClasspath(driverPath);
        }
        command.suppressEnvVariable(ENV_VAR_JAVA_TOOL_OPTIONS);
        return command;
    }

    private static long getGracefulStopTimeoutMs(Props props, ProcessProperties.Property property) {
        String value = Optional.ofNullable(props.value(property.getKey())).orElse(property.getDefaultValue());
        long gracePeriod = 30000L;
        return ProcessProperties.parseTimeoutMs((ProcessProperties.Property)property, (String)value) + gracePeriod;
    }

    private <T extends JvmOptions> void addProxyJvmOptions(JvmOptions<T> jvmOptions) {
        for (String key : PROXY_PROPERTY_KEYS) {
            this.getPropsValue(key).ifPresent(val -> jvmOptions.add("-D" + key + "=" + val));
        }
        this.setSystemPropertyToDefaultIfNotSet(jvmOptions, ProcessProperties.Property.HTTPS_PROXY_HOST.getKey(), ProcessProperties.Property.HTTP_PROXY_HOST.getKey());
        this.setSystemPropertyToDefaultIfNotSet(jvmOptions, ProcessProperties.Property.HTTPS_PROXY_PORT.getKey(), ProcessProperties.Property.HTTP_PROXY_PORT.getKey());
    }

    private void setSystemPropertyToDefaultIfNotSet(JvmOptions jvmOptions, String httpsProperty, String httpProperty) {
        Optional<String> httpValue = this.getPropsValue(httpProperty);
        Optional<String> httpsValue = this.getPropsValue(httpsProperty);
        if (!httpsValue.isPresent() && httpValue.isPresent()) {
            jvmOptions.add("-D" + httpsProperty + "=" + httpValue.get());
        }
    }

    private Optional<String> getPropsValue(String key) {
        return Optional.ofNullable(this.props.value(key));
    }
}

