/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.taskprocessor;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.taskprocessor.CeTaskProcessor;
import org.sonar.ce.taskprocessor.CeTaskProcessorRepository;

public class CeTaskProcessorRepositoryImpl
implements CeTaskProcessorRepository {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final Map<String, CeTaskProcessor> taskProcessorByCeTaskType;

    public CeTaskProcessorRepositoryImpl(CeTaskProcessor[] taskProcessors) {
        this.taskProcessorByCeTaskType = CeTaskProcessorRepositoryImpl.indexTaskProcessors(taskProcessors);
    }

    @Override
    public Optional<CeTaskProcessor> getForCeTask(CeTask ceTask) {
        return Optional.ofNullable(this.taskProcessorByCeTaskType.get(ceTask.getType()));
    }

    private static Map<String, CeTaskProcessor> indexTaskProcessors(CeTaskProcessor[] taskProcessors) {
        Multimap<String, CeTaskProcessor> permissiveIndex = CeTaskProcessorRepositoryImpl.buildPermissiveCeTaskProcessorIndex(taskProcessors);
        CeTaskProcessorRepositoryImpl.checkUniqueHandlerPerCeTaskType(permissiveIndex);
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)permissiveIndex.asMap(), (Function)CeTaskProcessorCollectionToFirstElement.INSTANCE));
    }

    private static Multimap<String, CeTaskProcessor> buildPermissiveCeTaskProcessorIndex(CeTaskProcessor[] taskProcessors) {
        ArrayListMultimap permissiveIndex = ArrayListMultimap.create((int)taskProcessors.length, (int)1);
        for (CeTaskProcessor taskProcessor : taskProcessors) {
            for (String ceTaskType : taskProcessor.getHandledCeTaskTypes()) {
                permissiveIndex.put((Object)ceTaskType, (Object)taskProcessor);
            }
        }
        return permissiveIndex;
    }

    private static void checkUniqueHandlerPerCeTaskType(Multimap<String, CeTaskProcessor> permissiveIndex) {
        for (Map.Entry entry : permissiveIndex.asMap().entrySet()) {
            Preconditions.checkArgument((((Collection)entry.getValue()).size() == 1 ? 1 : 0) != 0, (Object)String.format("There can be only one CeTaskProcessor instance registered as the processor for CeTask type %s. More than one found. Please fix your configuration: %s", entry.getKey(), COMMA_JOINER.join((Iterable)FluentIterable.from((Iterable)((Iterable)entry.getValue())).transform((Function)ToClassName.INSTANCE).toSortedList(String.CASE_INSENSITIVE_ORDER))));
        }
    }

    private static enum CeTaskProcessorCollectionToFirstElement implements Function<Collection<CeTaskProcessor>, CeTaskProcessor>
    {
        INSTANCE;


        @Nonnull
        public CeTaskProcessor apply(@Nonnull Collection<CeTaskProcessor> input) {
            return input.iterator().next();
        }
    }

    private static enum ToClassName implements Function<Object, String>
    {
        INSTANCE;


        @Nonnull
        public String apply(@Nonnull Object input) {
            return input.getClass().getName();
        }
    }
}

