/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ce.ws;

import com.google.protobuf.Message;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.ce.CeTaskMessageDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.ce.ws.CeWsAction;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Ce;

public class AnalysisStatusAction
implements CeWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public AnalysisStatusAction(UserSession userSession, DbClient dbClient, ComponentFinder componentFinder) {
        this.userSession = userSession;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    @Override
    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("analysis_status").setDescription("Get the analysis status of a given component: a project, branch or pull request.<br>Requires the following permission: 'Browse' on the specified component.").setSince("7.4").setResponseExample(this.getClass().getResource("analysis_status-example.json")).setInternal(true).setHandler((RequestHandler)this);
        action.createParam("component").setRequired(true).setExampleValue((Object)"my_project");
        action.createParam("branch").setDescription("Branch key").setExampleValue((Object)"feature/my_branch");
        action.createParam("pullRequest").setDescription("Pull request id").setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) throws Exception {
        String componentKey = request.mandatoryParam("component");
        String branchKey = request.param("branch");
        String pullRequestKey = request.param("pullRequest");
        WsUtils.checkRequest(branchKey == null || pullRequestKey == null, "Parameters '%s' and '%s' must not be specified at the same time", "branch", "pullRequest");
        this.doHandle(request, response, componentKey, branchKey, pullRequestKey);
    }

    private void doHandle(Request request, Response response, String componentKey, @Nullable String branchKey, @Nullable String pullRequestKey) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(dbSession, componentKey, branchKey, pullRequestKey);
            this.userSession.checkComponentPermission("user", component);
            WsUtils.checkRequest(AnalysisStatusAction.isProject(component), "Component '%s' must be a project.", componentKey);
            Ce.AnalysisStatusWsResponse.Builder responseBuilder = Ce.AnalysisStatusWsResponse.newBuilder();
            CeActivityDto lastActivity = this.dbClient.ceActivityDao().selectLastByComponentUuidAndTaskType(dbSession, component.uuid(), "REPORT").orElse(null);
            responseBuilder.setComponent(this.formatComponent(dbSession, component, lastActivity, branchKey, pullRequestKey));
            WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
        }
    }

    private static boolean isProject(ComponentDto project) {
        return "PRJ".equals(project.scope()) && "TRK".equals(project.qualifier());
    }

    private ComponentDto loadComponent(DbSession dbSession, String componentKey, @Nullable String branchKey, @Nullable String pullRequestKey) {
        if (branchKey != null) {
            return this.componentFinder.getByKeyAndBranch(dbSession, componentKey, branchKey);
        }
        if (pullRequestKey != null) {
            return this.componentFinder.getByKeyAndPullRequest(dbSession, componentKey, pullRequestKey);
        }
        return this.componentFinder.getByKey(dbSession, componentKey);
    }

    private Ce.AnalysisStatusWsResponse.Component formatComponent(DbSession dbSession, ComponentDto component, @Nullable CeActivityDto lastActivity, @Nullable String branchKey, @Nullable String pullRequestKey) {
        Ce.AnalysisStatusWsResponse.Component.Builder builder = Ce.AnalysisStatusWsResponse.Component.newBuilder().setOrganization(this.getOrganizationKey(dbSession, component)).setKey(component.getKey()).setName(component.name());
        if (branchKey != null) {
            builder.setBranch(branchKey);
        } else if (pullRequestKey != null) {
            builder.setPullRequest(pullRequestKey);
        }
        if (lastActivity != null) {
            List warnings = this.dbClient.ceTaskMessageDao().selectByTask(dbSession, lastActivity.getUuid()).stream().map(CeTaskMessageDto::getMessage).collect(Collectors.toList());
            builder.addAllWarnings(warnings);
        }
        return builder.build();
    }

    private String getOrganizationKey(DbSession dbSession, ComponentDto component) {
        String organizationUuid = component.getOrganizationUuid();
        return ((OrganizationDto)this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid).orElseThrow(() -> new IllegalStateException("Unknown organization: " + organizationUuid))).getKey();
    }
}

