/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.component.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.component.ws.ComponentViewerJsonWriter;
import org.sonar.server.component.ws.ComponentsWsAction;
import org.sonar.server.user.UserSession;

public class AppAction
implements ComponentsWsAction {
    private static final String PARAM_COMPONENT_ID = "componentId";
    private static final String PARAM_COMPONENT = "component";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final ComponentViewerJsonWriter componentViewerJsonWriter;

    public AppAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder, ComponentViewerJsonWriter componentViewerJsonWriter) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.componentViewerJsonWriter = componentViewerJsonWriter;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("app").setDescription("Coverage data required for rendering the component viewer.<br>Requires the following permission: 'Browse'.").setResponseExample(this.getClass().getResource("app-example.json")).setSince("4.4").setChangelog(new Change[]{new Change("7.6", String.format("The use of module keys in parameter '%s' is deprecated", PARAM_COMPONENT))}).setInternal(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_COMPONENT_ID).setDescription("Component ID").setDeprecatedSince("6.4").setDeprecatedKey("uuid", "6.4").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam(PARAM_COMPONENT).setDescription("Component key").setExampleValue((Object)"my_project").setSince("6.4");
        action.createParam("branch").setDescription("Branch key").setSince("6.6").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam("pullRequest").setDescription("Pull request id").setSince("7.1").setInternal(true).setExampleValue((Object)"5461");
    }

    public void handle(Request request, Response response) {
        try (DbSession session = this.dbClient.openSession(false);){
            ComponentDto component = this.loadComponent(session, request);
            this.userSession.checkComponentPermission("user", component);
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            this.componentViewerJsonWriter.writeComponent(json, component, this.userSession, session);
            AppAction.appendPermissions(json, this.userSession);
            this.componentViewerJsonWriter.writeMeasures(json, component, session);
            json.endObject();
            json.close();
        }
    }

    private ComponentDto loadComponent(DbSession dbSession, Request request) {
        String componentUuid = request.param(PARAM_COMPONENT_ID);
        String branch = request.param("branch");
        String pullRequest = request.param("pullRequest");
        Preconditions.checkArgument((componentUuid == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{PARAM_COMPONENT_ID, "branch", "pullRequest"});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentUuid, request.param(PARAM_COMPONENT), ComponentFinder.ParamNames.COMPONENT_ID_AND_COMPONENT);
        }
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, request.mandatoryParam(PARAM_COMPONENT), branch, pullRequest);
    }

    private static void appendPermissions(JsonWriter json, UserSession userSession) {
        json.prop("canMarkAsFavorite", userSession.isLoggedIn());
    }
}

