/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.debt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.picocontainer.Startable;
import org.sonar.api.Plugin;
import org.sonar.api.server.ServerSide;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginRepository;

@ServerSide
public class DebtModelPluginRepository
implements Startable {
    public static final String DEFAULT_MODEL = "technical-debt";
    private static final String XML_FILE_SUFFIX = "-model.xml";
    private static final String XML_FILE_PREFIX = "com/sonar/sqale/";
    private String xmlFilePrefix;
    private PluginRepository pluginRepository;
    private Map<String, ClassLoader> contributingPluginKeyToClassLoader;

    public DebtModelPluginRepository(PluginRepository pluginRepository) {
        this.pluginRepository = pluginRepository;
        this.xmlFilePrefix = XML_FILE_PREFIX;
    }

    @VisibleForTesting
    DebtModelPluginRepository(PluginRepository pluginRepository, String xmlFilePrefix) {
        this.pluginRepository = pluginRepository;
        this.xmlFilePrefix = xmlFilePrefix;
    }

    @VisibleForTesting
    DebtModelPluginRepository(Map<String, ClassLoader> contributingPluginKeyToClassLoader, String xmlFilePrefix) {
        this.contributingPluginKeyToClassLoader = contributingPluginKeyToClassLoader;
        this.xmlFilePrefix = xmlFilePrefix;
    }

    public void start() {
        this.findAvailableXMLFiles();
    }

    private void findAvailableXMLFiles() {
        if (this.contributingPluginKeyToClassLoader == null) {
            this.contributingPluginKeyToClassLoader = Maps.newTreeMap();
            this.contributingPluginKeyToClassLoader.put(DEFAULT_MODEL, this.getClass().getClassLoader());
            for (PluginInfo pluginInfo : this.pluginRepository.getPluginInfos()) {
                String pluginKey = pluginInfo.getKey();
                Plugin plugin = this.pluginRepository.getPluginInstance(pluginKey);
                ClassLoader classLoader = plugin.getClass().getClassLoader();
                if (classLoader.getResource(this.getXMLFilePath(pluginKey)) == null) continue;
                this.contributingPluginKeyToClassLoader.put(pluginKey, classLoader);
            }
        }
        this.contributingPluginKeyToClassLoader = Collections.unmodifiableMap(this.contributingPluginKeyToClassLoader);
    }

    @VisibleForTesting
    String getXMLFilePath(String model) {
        return this.xmlFilePrefix + model + XML_FILE_SUFFIX;
    }

    public Collection<String> getContributingPluginList() {
        return Lists.newArrayList(this.contributingPluginKeyToClassLoader.keySet());
    }

    public Reader createReaderForXMLFile(String pluginKey) {
        ClassLoader classLoader = this.contributingPluginKeyToClassLoader.get(pluginKey);
        String xmlFilePath = this.getXMLFilePath(pluginKey);
        return new InputStreamReader(classLoader.getResourceAsStream(xmlFilePath), StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    Map<String, ClassLoader> getContributingPluginKeyToClassLoader() {
        return this.contributingPluginKeyToClassLoader;
    }

    public void stop() {
    }
}

