/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.sonar.api.rule.Severity;
import org.sonar.db.issue.IssueDto;
import org.sonar.server.issue.index.IssueQuery;

class IssuesFinderSort {
    private List<IssueDto> issues;
    private IssueQuery query;

    public IssuesFinderSort(List<IssueDto> issues, IssueQuery query) {
        this.issues = issues;
        this.query = query;
    }

    public List<IssueDto> sort() {
        String sort = this.query.sort();
        Boolean asc = this.query.asc();
        if (sort != null && asc != null) {
            return IssuesFinderSort.getIssueProcessor(sort).sort(this.issues, asc);
        }
        return this.issues;
    }

    private static IssueProcessor getIssueProcessor(String sort) {
        if ("SEVERITY".equals(sort)) {
            return new SeveritySortIssueProcessor();
        }
        if ("STATUS".equals(sort)) {
            return new StatusSortIssueProcessor();
        }
        if ("CREATION_DATE".equals(sort)) {
            return new CreationDateSortIssueProcessor();
        }
        if ("UPDATE_DATE".equals(sort)) {
            return new UpdateDateSortIssueProcessor();
        }
        if ("CLOSE_DATE".equals(sort)) {
            return new CloseDateSortIssueProcessor();
        }
        throw new IllegalArgumentException("Cannot sort on field : " + sort);
    }

    private static enum IssueDtoToSeverity implements Function<IssueDto, Integer>
    {
        INSTANCE;


        public Integer apply(@Nonnull IssueDto issueDto) {
            return Severity.ALL.indexOf(issueDto.getSeverity());
        }
    }

    static class CloseDateSortIssueProcessor
    extends DateSortRowProcessor {
        CloseDateSortIssueProcessor() {
        }

        @Override
        Date sortField(IssueDto issueDto) {
            return issueDto.getIssueCloseDate();
        }
    }

    static class UpdateDateSortIssueProcessor
    extends DateSortRowProcessor {
        UpdateDateSortIssueProcessor() {
        }

        @Override
        Date sortField(IssueDto issueDto) {
            return issueDto.getIssueUpdateDate();
        }
    }

    static class CreationDateSortIssueProcessor
    extends DateSortRowProcessor {
        CreationDateSortIssueProcessor() {
        }

        @Override
        Date sortField(IssueDto issueDto) {
            return issueDto.getIssueCreationDate();
        }
    }

    static abstract class DateSortRowProcessor
    implements IssueProcessor {
        DateSortRowProcessor() {
        }

        @Override
        public Function sortFieldFunction() {
            return new Function<IssueDto, Date>(){

                public Date apply(IssueDto issueDto) {
                    return this.sortField(issueDto);
                }
            };
        }

        abstract Date sortField(IssueDto var1);

        @Override
        public Ordering sortFieldOrdering(boolean ascending) {
            Ordering ordering = Ordering.natural().nullsLast();
            if (!ascending) {
                ordering = ordering.reverse();
            }
            return ordering;
        }
    }

    static class SeveritySortIssueProcessor
    implements IssueProcessor {
        SeveritySortIssueProcessor() {
        }

        @Override
        public Function sortFieldFunction() {
            return IssueDtoToSeverity.INSTANCE;
        }

        @Override
        public Ordering sortFieldOrdering(boolean ascending) {
            Ordering ordering = Ordering.natural().nullsLast();
            if (!ascending) {
                ordering = ordering.reverse();
            }
            return ordering;
        }
    }

    static class StatusSortIssueProcessor
    extends TextSortIssueProcessor {
        StatusSortIssueProcessor() {
        }

        @Override
        String sortField(IssueDto issueDto) {
            return issueDto.getStatus();
        }
    }

    static abstract class TextSortIssueProcessor
    implements IssueProcessor {
        TextSortIssueProcessor() {
        }

        @Override
        public Function sortFieldFunction() {
            return new Function<IssueDto, String>(){

                public String apply(IssueDto issueDto) {
                    return this.sortField(issueDto);
                }
            };
        }

        abstract String sortField(IssueDto var1);

        @Override
        public Ordering sortFieldOrdering(boolean ascending) {
            Ordering ordering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
            if (!ascending) {
                ordering = ordering.reverse();
            }
            return ordering;
        }
    }

    static interface IssueProcessor {
        public Function sortFieldFunction();

        public Ordering sortFieldOrdering(boolean var1);

        default public List<IssueDto> sort(Collection<IssueDto> issueDtos, boolean ascending) {
            Ordering ordering = this.sortFieldOrdering(ascending).onResultOf(this.sortFieldFunction());
            return ordering.immutableSortedCopy(issueDtos);
        }
    }
}

