/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.measure.custom.ws.CustomMeasureJsonWriter;
import org.sonar.server.measure.custom.ws.CustomMeasureValidator;
import org.sonar.server.measure.custom.ws.CustomMeasuresWsAction;
import org.sonar.server.user.UserSession;

public class SearchAction
implements CustomMeasuresWsAction {
    public static final String ACTION = "search";
    public static final String PARAM_PROJECT_ID = "projectId";
    public static final String PARAM_PROJECT_KEY = "projectKey";
    private final DbClient dbClient;
    private final CustomMeasureJsonWriter customMeasureJsonWriter;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public SearchAction(DbClient dbClient, CustomMeasureJsonWriter customMeasureJsonWriter, UserSession userSession, ComponentFinder componentFinder) {
        this.dbClient = dbClient;
        this.customMeasureJsonWriter = customMeasureJsonWriter;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("List custom measures. The project id or project key must be provided.<br />Requires 'Administer System' permission or 'Administer' permission on the project.").setSince("5.2").setDeprecatedSince("7.4").addFieldsParam(CustomMeasureJsonWriter.OPTIONAL_FIELDS).addPagingParams(100, 500).setResponseExample(this.getClass().getResource("example-search.json")).setHandler((RequestHandler)this);
        action.createParam(PARAM_PROJECT_ID).setDescription("Project id").setExampleValue((Object)"ce4c03d6-430f-40a9-b777-ad877c00aa4d");
        action.createParam(PARAM_PROJECT_KEY).setDescription("Project key").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        String projectUuid = request.param(PARAM_PROJECT_ID);
        String projectKey = request.param(PARAM_PROJECT_KEY);
        List fieldsToReturn = request.paramAsStrings("f");
        SearchOptions searchOptions = new SearchOptions().setPage(request.mandatoryParamAsInt("p"), request.mandatoryParamAsInt("ps"));
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = this.componentFinder.getByUuidOrKey(dbSession, projectUuid, projectKey, ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
            CustomMeasureValidator.checkPermissions(this.userSession, component);
            Long lastAnalysisDateMs = this.searchLastSnapshotDate(dbSession, component);
            List<CustomMeasureDto> customMeasures = this.searchCustomMeasures(dbSession, component, searchOptions);
            int nbCustomMeasures = this.countTotalOfCustomMeasures(dbSession, component);
            Map<String, UserDto> usersByUuid = this.usersByUuid(dbSession, customMeasures);
            Map<Integer, MetricDto> metricsById = this.metricsById(dbSession, customMeasures);
            this.writeResponse(response, customMeasures, nbCustomMeasures, component, metricsById, usersByUuid, lastAnalysisDateMs, searchOptions, fieldsToReturn);
        }
    }

    @CheckForNull
    private Long searchLastSnapshotDate(DbSession dbSession, ComponentDto component) {
        Optional lastSnapshot = this.dbClient.snapshotDao().selectLastAnalysisByComponentUuid(dbSession, component.projectUuid());
        return lastSnapshot.isPresent() ? ((SnapshotDto)lastSnapshot.get()).getBuildDate() : null;
    }

    private int countTotalOfCustomMeasures(DbSession dbSession, ComponentDto project) {
        return this.dbClient.customMeasureDao().countByComponentUuid(dbSession, project.uuid());
    }

    private List<CustomMeasureDto> searchCustomMeasures(DbSession dbSession, ComponentDto project, SearchOptions searchOptions) {
        return this.dbClient.customMeasureDao().selectByComponentUuid(dbSession, project.uuid(), searchOptions.getOffset(), searchOptions.getLimit());
    }

    private void writeResponse(Response response, List<CustomMeasureDto> customMeasures, int nbCustomMeasures, ComponentDto project, Map<Integer, MetricDto> metricsById, Map<String, UserDto> usersByUuid, @Nullable Long lastAnalysisDate, SearchOptions searchOptions, @Nullable List<String> fieldsToReturn) {
        JsonWriter json = response.newJsonWriter();
        json.beginObject();
        this.writeUsers(json, customMeasures, project, metricsById, usersByUuid, lastAnalysisDate, fieldsToReturn);
        searchOptions.writeJson(json, (long)nbCustomMeasures);
        json.endObject();
        json.close();
    }

    private void writeUsers(JsonWriter json, List<CustomMeasureDto> customMeasures, ComponentDto project, Map<Integer, MetricDto> metricsById, Map<String, UserDto> usersByUuids, @Nullable Long lastAnalysisTimestamp, @Nullable Collection<String> fieldsToReturn) {
        json.name("customMeasures");
        json.beginArray();
        for (CustomMeasureDto customMeasure : customMeasures) {
            boolean pending = lastAnalysisTimestamp == null || lastAnalysisTimestamp < customMeasure.getUpdatedAt();
            this.customMeasureJsonWriter.write(json, customMeasure, metricsById.get(customMeasure.getMetricId()), project, usersByUuids.get(customMeasure.getUserUuid()), pending, fieldsToReturn);
        }
        json.endArray();
    }

    private Map<Integer, MetricDto> metricsById(DbSession dbSession, List<CustomMeasureDto> customMeasures) {
        List metrics = this.dbClient.metricDao().selectByIds(dbSession, (Set)Sets.newHashSet((Iterable)Lists.transform(customMeasures, (Function)CustomMeasureToMetricIdFunction.INSTANCE)));
        return Maps.uniqueIndex((Iterable)metrics, (Function)MetricToIdFunction.INSTANCE);
    }

    private Map<String, UserDto> usersByUuid(DbSession dbSession, List<CustomMeasureDto> customMeasures) {
        Set userUuids = (Set)customMeasures.stream().map(CustomMeasureDto::getUserUuid).collect(MoreCollectors.toSet());
        List users = this.dbClient.userDao().selectByUuids(dbSession, (Collection)userUuids);
        return (Map)users.stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
    }

    private static enum MetricToIdFunction implements Function<MetricDto, Integer>
    {
        INSTANCE;


        public Integer apply(@Nonnull MetricDto metric) {
            return metric.getId();
        }
    }

    private static enum CustomMeasureToMetricIdFunction implements Function<CustomMeasureDto, Integer>
    {
        INSTANCE;


        public Integer apply(@Nonnull CustomMeasureDto customMeasure) {
            return customMeasure.getMetricId();
        }
    }
}

