/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.protobuf.Message;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.RequestValidator;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.permission.ws.template.PermissionTemplateDtoToPermissionTemplateResponse;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Permissions;

public class CreateTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final System2 system;
    private final PermissionWsSupport wsSupport;

    public CreateTemplateAction(DbClient dbClient, UserSession userSession, System2 system, PermissionWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.system = system;
        this.wsSupport = wsSupport;
    }

    private static CreateTemplateRequest toCreateTemplateWsRequest(Request request) {
        return new CreateTemplateRequest().setName(request.mandatoryParam("name")).setDescription(request.param("description")).setProjectKeyPattern(request.param("projectKeyPattern")).setOrganization(request.param("organization"));
    }

    private static Permissions.CreateTemplateWsResponse buildResponse(PermissionTemplateDto permissionTemplateDto) {
        Permissions.PermissionTemplate permissionTemplateBuilder = PermissionTemplateDtoToPermissionTemplateResponse.toPermissionTemplateResponse(permissionTemplateDto);
        return Permissions.CreateTemplateWsResponse.newBuilder().setPermissionTemplate(permissionTemplateBuilder).build();
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create_template").setDescription("Create a permission template.<br />Requires the following permission: 'Administer System'.").setResponseExample(this.getClass().getResource("create_template-example.json")).setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        action.createParam("name").setRequired(true).setDescription("Name").setExampleValue((Object)"Financial Service Permissions");
        WsParameters.createTemplateProjectKeyPatternParameter(action);
        WsParameters.createTemplateDescriptionParameter(action);
        WsParameters.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request request, Response response) throws Exception {
        Permissions.CreateTemplateWsResponse createTemplateWsResponse = this.doHandle(CreateTemplateAction.toCreateTemplateWsRequest(request));
        WsUtils.writeProtobuf((Message)createTemplateWsResponse, request, response);
    }

    private Permissions.CreateTemplateWsResponse doHandle(CreateTemplateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.wsSupport.findOrganization(dbSession, request.getOrganization());
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, org.getUuid());
            this.validateTemplateNameForCreation(dbSession, org, request.getName());
            RequestValidator.validateProjectPattern(request.getProjectKeyPattern());
            PermissionTemplateDto permissionTemplate = this.insertTemplate(dbSession, org, request);
            Permissions.CreateTemplateWsResponse createTemplateWsResponse = CreateTemplateAction.buildResponse(permissionTemplate);
            return createTemplateWsResponse;
        }
    }

    private void validateTemplateNameForCreation(DbSession dbSession, OrganizationDto org, String name) {
        PermissionTemplateDto permissionTemplateWithSameName = this.dbClient.permissionTemplateDao().selectByName(dbSession, org.getUuid(), name);
        WsUtils.checkRequest(permissionTemplateWithSameName == null, String.format("A template with the name '%s' already exists (case insensitive).", name), new Object[0]);
    }

    private PermissionTemplateDto insertTemplate(DbSession dbSession, OrganizationDto org, CreateTemplateRequest request) {
        Date now = new Date(this.system.now());
        PermissionTemplateDto template = this.dbClient.permissionTemplateDao().insert(dbSession, new PermissionTemplateDto().setUuid(Uuids.create()).setOrganizationUuid(org.getUuid()).setName(request.getName()).setDescription(request.getDescription()).setKeyPattern(request.getProjectKeyPattern()).setCreatedAt(now).setUpdatedAt(now));
        dbSession.commit();
        return template;
    }

    private static class CreateTemplateRequest {
        private String description;
        private String name;
        private String projectKeyPattern;
        private String organization;

        private CreateTemplateRequest() {
        }

        @CheckForNull
        public String getDescription() {
            return this.description;
        }

        public CreateTemplateRequest setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public CreateTemplateRequest setName(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CheckForNull
        public String getProjectKeyPattern() {
            return this.projectKeyPattern;
        }

        public CreateTemplateRequest setProjectKeyPattern(@Nullable String projectKeyPattern) {
            this.projectKeyPattern = projectKeyPattern;
            return this;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        public CreateTemplateRequest setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }
    }
}

