/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDao;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.RequestValidator;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;

public class RemoveProjectCreatorFromTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;
    private final System2 system;
    private final WsParameters wsParameters;
    private final RequestValidator requestValidator;

    public RemoveProjectCreatorFromTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession, System2 system, WsParameters wsParameters, RequestValidator requestValidator) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
        this.system = system;
        this.wsParameters = wsParameters;
        this.requestValidator = requestValidator;
    }

    private RemoveProjectCreatorFromTemplateRequest toWsRequest(Request request) {
        RemoveProjectCreatorFromTemplateRequest wsRequest = RemoveProjectCreatorFromTemplateRequest.builder().setPermission(request.mandatoryParam("permission")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName")).build();
        this.requestValidator.validateProjectPermission(wsRequest.getPermission());
        return wsRequest;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_project_creator_from_template").setDescription("Remove a project creator from a permission template.<br>Requires the following permission: 'Administer System'.").setSince("6.0").setPost(true).setHandler((RequestHandler)this);
        WsParameters.createTemplateParameters(action);
        this.wsParameters.createProjectPermissionParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(this.toWsRequest(request));
        response.noContent();
    }

    private void doHandle(RemoveProjectCreatorFromTemplateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            PermissionTemplateCharacteristicDao dao = this.dbClient.permissionTemplateCharacteristicDao();
            dao.selectByPermissionAndTemplateId(dbSession, request.getPermission(), template.getId().longValue()).ifPresent(permissionTemplateCharacteristicDto -> this.updateTemplateCharacteristic(dbSession, (PermissionTemplateCharacteristicDto)permissionTemplateCharacteristicDto));
        }
    }

    private void updateTemplateCharacteristic(DbSession dbSession, PermissionTemplateCharacteristicDto templatePermission) {
        PermissionTemplateCharacteristicDto targetTemplatePermission = templatePermission.setUpdatedAt(this.system.now()).setWithProjectCreator(false);
        this.dbClient.permissionTemplateCharacteristicDao().update(dbSession, targetTemplatePermission);
        dbSession.commit();
    }

    public static class Builder {
        private String templateId;
        private String organization;
        private String templateName;
        private String permission;

        private Builder() {
        }

        public Builder setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }

        public Builder setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder setPermission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public RemoveProjectCreatorFromTemplateRequest build() {
            return new RemoveProjectCreatorFromTemplateRequest(this);
        }
    }

    private static class RemoveProjectCreatorFromTemplateRequest {
        private final String templateId;
        private final String organization;
        private final String templateName;
        private final String permission;

        private RemoveProjectCreatorFromTemplateRequest(Builder builder) {
            this.templateId = builder.templateId;
            this.organization = builder.organization;
            this.templateName = builder.templateName;
            this.permission = Objects.requireNonNull(builder.permission);
        }

        @CheckForNull
        public String getTemplateId() {
            return this.templateId;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        public String getPermission() {
            return this.permission;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

