/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.platformlevel;

import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.EditionProvider;
import org.sonar.core.platform.PlatformEditionProvider;
import org.sonar.server.app.ProcessCommandWrapper;
import org.sonar.server.es.IndexerStartupTask;
import org.sonar.server.organization.DefaultOrganizationEnforcer;
import org.sonar.server.platform.ServerLifecycleNotifier;
import org.sonar.server.platform.platformlevel.PlatformLevel;
import org.sonar.server.platform.web.RegisterServletFilters;
import org.sonar.server.qualitygate.ProjectsInWarningDaemon;
import org.sonar.server.qualitygate.RegisterQualityGates;
import org.sonar.server.qualityprofile.BuiltInQProfileInsertImpl;
import org.sonar.server.qualityprofile.BuiltInQProfileLoader;
import org.sonar.server.qualityprofile.BuiltInQProfileUpdateImpl;
import org.sonar.server.qualityprofile.BuiltInQualityProfilesUpdateListener;
import org.sonar.server.qualityprofile.RegisterQualityProfiles;
import org.sonar.server.rule.RegisterRules;
import org.sonar.server.rule.WebServerRuleFinder;
import org.sonar.server.startup.DeprecatedWebhookUsageCheck;
import org.sonar.server.startup.GeneratePluginIndex;
import org.sonar.server.startup.RegisterMetrics;
import org.sonar.server.startup.RegisterPermissionTemplates;
import org.sonar.server.startup.RegisterPlugins;
import org.sonar.server.startup.RenameDeprecatedPropertyKeys;
import org.sonar.server.user.DoPrivileged;
import org.sonar.server.user.ThreadLocalUserSession;

public class PlatformLevelStartup
extends PlatformLevel {
    public PlatformLevelStartup(PlatformLevel parent) {
        super("startup tasks", parent);
    }

    @Override
    protected void configureLevel() {
        this.add(GeneratePluginIndex.class, RegisterPlugins.class, ServerLifecycleNotifier.class, DefaultOrganizationEnforcer.class);
        this.addIfStartupLeader(IndexerStartupTask.class, RegisterMetrics.class, RegisterQualityGates.class, RegisterRules.class);
        this.add(BuiltInQProfileLoader.class);
        this.addIfStartupLeader(BuiltInQualityProfilesUpdateListener.class, BuiltInQProfileInsertImpl.class, BuiltInQProfileUpdateImpl.class, DeprecatedWebhookUsageCheck.class, RegisterQualityProfiles.class, RegisterPermissionTemplates.class, RenameDeprecatedPropertyKeys.class);
        this.add(RegisterServletFilters.class);
    }

    @Override
    public PlatformLevel start() {
        DoPrivileged.execute(new DoPrivileged.Task(this.get(ThreadLocalUserSession.class)){

            @Override
            protected void doPrivileged() {
                PlatformLevelStartup.super.start();
                PlatformLevelStartup.this.getOptional(IndexerStartupTask.class).ifPresent(IndexerStartupTask::execute);
                PlatformLevelStartup.this.get(ProjectsInWarningDaemon.class).notifyStart();
                PlatformLevelStartup.this.get(ServerLifecycleNotifier.class).notifyStart();
                PlatformLevelStartup.this.get(ProcessCommandWrapper.class).notifyOperational();
                PlatformLevelStartup.this.get(WebServerRuleFinder.class).stopCaching();
                Loggers.get(PlatformLevelStartup.class).info("Running {} Edition", (Object)PlatformLevelStartup.this.get(PlatformEditionProvider.class).get().map(EditionProvider.Edition::getLabel).orElse(""));
            }
        });
        return this;
    }
}

