/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonar.core.util.stream.MoreCollectors;

public class RedirectFilter
implements Filter {
    private static final String EMPTY = "";
    private static final List<Redirect> REDIRECTS = ImmutableList.of((Object)RedirectFilter.newSimpleRedirect("/api", "/api/webservices/list"));

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String path = RedirectFilter.extractPath(request);
        Predicate<Redirect> match = redirect -> redirect.test(path);
        List redirects = (List)REDIRECTS.stream().filter(match).collect(MoreCollectors.toList());
        switch (redirects.size()) {
            case 0: {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                break;
            }
            case 1: {
                response.sendRedirect(((Redirect)redirects.get(0)).apply(request));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Multiple redirects have been found for '%s'", path));
            }
        }
    }

    public static Redirect newSimpleRedirect(final String from, final String to) {
        return new Redirect(){

            @Override
            public boolean test(String path) {
                return from.equals(path);
            }

            @Override
            public String apply(HttpServletRequest request) {
                return String.format("%s%s", request.getContextPath(), to);
            }
        };
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private static String extractPath(HttpServletRequest request) {
        return RedirectFilter.sanitizePath(request.getRequestURI().replaceFirst(request.getContextPath(), EMPTY));
    }

    private static String sanitizePath(String path) {
        if (path.length() > 1 && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static interface Redirect
    extends Predicate<String>,
    Function<HttpServletRequest, String> {
        @Override
        public boolean test(String var1);

        @Override
        public String apply(HttpServletRequest var1);
    }
}

