/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.io.Serializable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessId;
import org.sonar.process.cluster.hz.DistributedCall;
import org.sonar.process.cluster.hz.HazelcastMember;
import org.sonar.process.cluster.hz.HazelcastMemberSelectors;
import org.sonar.server.log.ServerLogging;
import org.sonar.server.platform.ws.ChangeLogLevelService;

public class ChangeLogLevelClusterService
implements ChangeLogLevelService {
    private static final long CLUSTER_TIMEOUT_MILLIS = 5000L;
    private static final Logger LOGGER = Loggers.get(ChangeLogLevelClusterService.class);
    private final HazelcastMember member;

    public ChangeLogLevelClusterService(HazelcastMember member) {
        this.member = member;
    }

    public ChangeLogLevelClusterService() {
        this(null);
    }

    @Override
    public void changeLogLevel(LoggerLevel level) throws InterruptedException {
        this.member.call(ChangeLogLevelClusterService.setLogLevelForNode(level), HazelcastMemberSelectors.selectorForProcessIds((ProcessId[])new ProcessId[]{ProcessId.WEB_SERVER, ProcessId.COMPUTE_ENGINE}), 5000L).propagateExceptions();
    }

    private static DistributedCall<Object> setLogLevelForNode(LoggerLevel level) {
        return (DistributedCall & Serializable)() -> {
            try {
                ServerLogging.changeLevelFromHazelcastDistributedQuery((LoggerLevel)level);
            }
            catch (Exception e) {
                LOGGER.error("Setting log level to '" + level.name() + "' in this cluster node failed", (Throwable)e);
                throw new IllegalStateException("Setting log level to '" + level.name() + "' in this cluster node failed", e);
            }
            return null;
        };
    }
}

