/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.ActiveRuleParamDto;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.OrgQProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileInsert;
import org.sonar.server.qualityprofile.index.ActiveRuleIndexer;
import org.sonar.server.util.TypeValidations;

public class BuiltInQProfileInsertImpl
implements BuiltInQProfileInsert {
    private final DbClient dbClient;
    private final System2 system2;
    private final UuidFactory uuidFactory;
    private final TypeValidations typeValidations;
    private final ActiveRuleIndexer activeRuleIndexer;
    private RuleRepository ruleRepository;

    public BuiltInQProfileInsertImpl(DbClient dbClient, System2 system2, UuidFactory uuidFactory, TypeValidations typeValidations, ActiveRuleIndexer activeRuleIndexer) {
        this.dbClient = dbClient;
        this.system2 = system2;
        this.uuidFactory = uuidFactory;
        this.typeValidations = typeValidations;
        this.activeRuleIndexer = activeRuleIndexer;
    }

    @Override
    public void create(DbSession dbSession, DbSession batchDbSession, BuiltInQProfile builtInQProfile) {
        this.initRuleRepository(batchDbSession);
        Date now = new Date(this.system2.now());
        RulesProfileDto ruleProfile = this.insertRulesProfile(dbSession, builtInQProfile, now);
        List changes = (List)builtInQProfile.getActiveRules().stream().map(activeRule -> this.insertActiveRule(dbSession, ruleProfile, (BuiltInQProfile.ActiveRule)activeRule, now.getTime())).collect(MoreCollectors.toList());
        changes.forEach(change -> this.dbClient.qProfileChangeDao().insert(batchDbSession, change.toDto(null)));
        this.associateToOrganizations(dbSession, batchDbSession, builtInQProfile, ruleProfile);
        batchDbSession.commit();
        this.activeRuleIndexer.commitAndIndex(dbSession, (Collection)changes);
    }

    private void associateToOrganizations(DbSession dbSession, DbSession batchDbSession, BuiltInQProfile builtIn, RulesProfileDto rulesProfileDto) {
        List orgUuids = this.dbClient.organizationDao().selectAllUuids(dbSession);
        Set orgUuidsWithoutDefault = this.dbClient.defaultQProfileDao().selectUuidsOfOrganizationsWithoutDefaultProfile(dbSession, builtIn.getLanguage());
        ArrayList defaults = new ArrayList();
        orgUuids.forEach(orgUuid -> {
            OrgQProfileDto dto = new OrgQProfileDto().setOrganizationUuid(orgUuid).setRulesProfileUuid(rulesProfileDto.getKee()).setUuid(this.uuidFactory.create());
            if (builtIn.isDefault() && orgUuidsWithoutDefault.contains(orgUuid)) {
                defaults.add(new DefaultQProfileDto().setQProfileUuid(dto.getUuid()).setOrganizationUuid(orgUuid).setLanguage(builtIn.getLanguage()));
            }
            this.dbClient.qualityProfileDao().insert(batchDbSession, dto);
        });
        defaults.forEach(defaultQProfileDto -> this.dbClient.defaultQProfileDao().insertOrUpdate(dbSession, defaultQProfileDto));
    }

    private void initRuleRepository(DbSession dbSession) {
        if (this.ruleRepository == null) {
            this.ruleRepository = new RuleRepository(this.dbClient, dbSession);
        }
    }

    private RulesProfileDto insertRulesProfile(DbSession dbSession, BuiltInQProfile builtIn, Date now) {
        RulesProfileDto dto = new RulesProfileDto().setKee(this.uuidFactory.create()).setName(builtIn.getName()).setLanguage(builtIn.getLanguage()).setIsBuiltIn(true).setRulesUpdatedAtAsDate(now);
        this.dbClient.qualityProfileDao().insert(dbSession, dto);
        return dto;
    }

    private ActiveRuleChange insertActiveRule(DbSession dbSession, RulesProfileDto rulesProfileDto, BuiltInQProfile.ActiveRule activeRule, long now) {
        RuleKey ruleKey = activeRule.getRuleKey();
        RuleDefinitionDto ruleDefinitionDto = (RuleDefinitionDto)this.ruleRepository.getDefinition(ruleKey).orElseThrow(() -> new IllegalStateException("RuleDefinition not found for key " + ruleKey));
        ActiveRuleDto dto = new ActiveRuleDto();
        dto.setProfileId(rulesProfileDto.getId());
        dto.setRuleId(ruleDefinitionDto.getId());
        dto.setKey(ActiveRuleKey.of((RulesProfileDto)rulesProfileDto, (RuleKey)ruleDefinitionDto.getKey()));
        dto.setSeverity((String)MoreObjects.firstNonNull((Object)activeRule.getSeverity(), (Object)ruleDefinitionDto.getSeverityString()));
        dto.setUpdatedAt(now);
        dto.setCreatedAt(now);
        this.dbClient.activeRuleDao().insert(dbSession, dto);
        List<ActiveRuleParamDto> paramDtos = this.insertActiveRuleParams(dbSession, activeRule, dto);
        ActiveRuleChange change = new ActiveRuleChange(ActiveRuleChange.Type.ACTIVATED, dto, ruleDefinitionDto);
        change.setSeverity(dto.getSeverityString());
        paramDtos.forEach(paramDto -> change.setParameter(paramDto.getKey(), paramDto.getValue()));
        return change;
    }

    private List<ActiveRuleParamDto> insertActiveRuleParams(DbSession session, BuiltInQProfile.ActiveRule activeRule, ActiveRuleDto activeRuleDto) {
        Map valuesByParamKey = (Map)activeRule.getParams().stream().collect(MoreCollectors.uniqueIndex(BuiltInQualityProfilesDefinition.OverriddenParam::key, BuiltInQualityProfilesDefinition.OverriddenParam::overriddenValue));
        return (List)this.ruleRepository.getRuleParams(activeRule.getRuleKey()).stream().map(param -> {
            String activeRuleValue = (String)valuesByParamKey.get(param.getName());
            return this.createParamDto((RuleParamDto)param, activeRuleValue == null ? param.getDefaultValue() : activeRuleValue);
        }).filter(Objects::nonNull).peek(paramDto -> this.dbClient.activeRuleDao().insertParam(session, activeRuleDto, paramDto)).collect(MoreCollectors.toList());
    }

    @CheckForNull
    private ActiveRuleParamDto createParamDto(RuleParamDto param, @Nullable String value) {
        if (value == null) {
            return null;
        }
        ActiveRuleParamDto paramDto = ActiveRuleParamDto.createFor((RuleParamDto)param);
        paramDto.setValue(this.validateParam(param, value));
        return paramDto;
    }

    @CheckForNull
    private String validateParam(RuleParamDto ruleParam, String value) {
        RuleParamType ruleParamType = RuleParamType.parse((String)ruleParam.getType());
        if (ruleParamType.multiple()) {
            ArrayList values = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)value));
            this.typeValidations.validate(values, ruleParamType.type(), (List<String>)ruleParamType.values());
        } else {
            this.typeValidations.validate(value, ruleParamType.type(), (List<String>)ruleParamType.values());
        }
        return value;
    }

    private static class RuleRepository {
        private final Map<RuleKey, RuleDefinitionDto> definitions;
        private final Map<RuleKey, Set<RuleParamDto>> params;

        private RuleRepository(DbClient dbClient, DbSession session) {
            this.definitions = dbClient.ruleDao().selectAllDefinitions(session).stream().collect(Collectors.toMap(RuleDefinitionDto::getKey, Function.identity()));
            Map ruleIdsByKey = (Map)this.definitions.values().stream().collect(MoreCollectors.uniqueIndex(RuleDefinitionDto::getId, RuleDefinitionDto::getKey));
            this.params = new HashMap<RuleKey, Set<RuleParamDto>>(ruleIdsByKey.size());
            dbClient.ruleDao().selectRuleParamsByRuleKeys(session, this.definitions.keySet()).forEach(ruleParam -> this.params.compute((RuleKey)ruleIdsByKey.get(ruleParam.getRuleId()), (key, value) -> {
                if (value == null) {
                    return ImmutableSet.of((Object)ruleParam);
                }
                return ImmutableSet.copyOf((Collection)Sets.union((Set)value, Collections.singleton(ruleParam)));
            }));
        }

        private Optional<RuleDefinitionDto> getDefinition(RuleKey ruleKey) {
            return Optional.ofNullable(this.definitions.get(Objects.requireNonNull(ruleKey, "RuleKey can't be null")));
        }

        private Set<RuleParamDto> getRuleParams(RuleKey ruleKey) {
            Set<RuleParamDto> res = this.params.get(Objects.requireNonNull(ruleKey, "RuleKey can't be null"));
            return res == null ? Collections.emptySet() : res;
        }
    }
}

