/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.picocontainer.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.DefaultQProfileDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.RulesProfileDto;
import org.sonar.server.qualityprofile.ActiveRuleChange;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.qualityprofile.BuiltInQProfile;
import org.sonar.server.qualityprofile.BuiltInQProfileInsert;
import org.sonar.server.qualityprofile.BuiltInQProfileRepository;
import org.sonar.server.qualityprofile.BuiltInQProfileUpdate;
import org.sonar.server.qualityprofile.BuiltInQualityProfilesUpdateListener;
import org.sonar.server.qualityprofile.QProfileName;

@ServerSide
public class RegisterQualityProfiles
implements Startable {
    private static final Logger LOGGER = Loggers.get(RegisterQualityProfiles.class);
    private final BuiltInQProfileRepository builtInQProfileRepository;
    private final DbClient dbClient;
    private final BuiltInQProfileInsert builtInQProfileInsert;
    private final BuiltInQProfileUpdate builtInQProfileUpdate;
    private final BuiltInQualityProfilesUpdateListener builtInQualityProfilesNotification;
    private final System2 system2;

    public RegisterQualityProfiles(BuiltInQProfileRepository builtInQProfileRepository, DbClient dbClient, BuiltInQProfileInsert builtInQProfileInsert, BuiltInQProfileUpdate builtInQProfileUpdate, BuiltInQualityProfilesUpdateListener builtInQualityProfilesNotification, System2 system2) {
        this.builtInQProfileRepository = builtInQProfileRepository;
        this.dbClient = dbClient;
        this.builtInQProfileInsert = builtInQProfileInsert;
        this.builtInQProfileUpdate = builtInQProfileUpdate;
        this.builtInQualityProfilesNotification = builtInQualityProfilesNotification;
        this.system2 = system2;
    }

    public void start() {
        List<BuiltInQProfile> builtInQProfiles = this.builtInQProfileRepository.get();
        if (builtInQProfiles.isEmpty()) {
            return;
        }
        Profiler profiler = Profiler.create((Logger)Loggers.get(this.getClass())).startInfo("Register quality profiles");
        try (DbSession dbSession = this.dbClient.openSession(false);
             DbSession batchDbSession = this.dbClient.openSession(true);){
            long startDate = this.system2.now();
            Map<QProfileName, RulesProfileDto> persistedRuleProfiles = this.loadPersistedProfiles(dbSession);
            ArrayListMultimap changedProfiles = ArrayListMultimap.create();
            builtInQProfiles.forEach(arg_0 -> this.lambda$start$1(persistedRuleProfiles, dbSession, batchDbSession, (Multimap)changedProfiles, arg_0));
            if (!changedProfiles.isEmpty()) {
                long endDate = this.system2.now();
                this.builtInQualityProfilesNotification.onChange((Multimap<QProfileName, ActiveRuleChange>)changedProfiles, startDate, endDate);
            }
            this.ensureBuiltInDefaultQPContainsRules(dbSession);
        }
        profiler.stopDebug();
    }

    public void stop() {
    }

    private Map<QProfileName, RulesProfileDto> loadPersistedProfiles(DbSession dbSession) {
        return (Map)this.dbClient.qualityProfileDao().selectBuiltInRuleProfiles(dbSession).stream().collect(MoreCollectors.uniqueIndex(rp -> new QProfileName(rp.getLanguage(), rp.getName())));
    }

    private void create(DbSession dbSession, DbSession batchDbSession, BuiltInQProfile builtIn) {
        LOGGER.info("Register profile {}", (Object)builtIn.getQProfileName());
        this.renameOutdatedProfiles(dbSession, builtIn);
        this.builtInQProfileInsert.create(dbSession, batchDbSession, builtIn);
    }

    private List<ActiveRuleChange> update(DbSession dbSession, BuiltInQProfile definition, RulesProfileDto dbProfile) {
        LOGGER.info("Update profile {}", (Object)definition.getQProfileName());
        return this.builtInQProfileUpdate.update(dbSession, definition, dbProfile);
    }

    private void renameOutdatedProfiles(DbSession dbSession, BuiltInQProfile profile) {
        Collection uuids = this.dbClient.qualityProfileDao().selectUuidsOfCustomRulesProfiles(dbSession, profile.getLanguage(), profile.getName());
        if (uuids.isEmpty()) {
            return;
        }
        Profiler profiler = Profiler.createIfDebug((Logger)Loggers.get(this.getClass())).start();
        String newName = profile.getName() + " (outdated copy)";
        LOGGER.info("Rename Quality profiles [{}/{}] to [{}] in {}\u00a0organizations", new Object[]{profile.getLanguage(), profile.getName(), newName, uuids.size()});
        this.dbClient.qualityProfileDao().renameRulesProfilesAndCommit(dbSession, uuids, newName);
        profiler.stopDebug(String.format("%d Quality profiles renamed to [%s]", uuids.size(), newName));
    }

    private void ensureBuiltInDefaultQPContainsRules(DbSession dbSession) {
        Map rulesProfilesByLanguage = this.dbClient.qualityProfileDao().selectBuiltInRuleProfilesWithActiveRules(dbSession).stream().collect(Collectors.toMap(RulesProfileDto::getLanguage, Function.identity(), (oldValue, newValue) -> oldValue));
        this.dbClient.qualityProfileDao().selectDefaultBuiltInProfilesWithoutActiveRules(dbSession, rulesProfilesByLanguage.keySet()).forEach(qp -> {
            RulesProfileDto rulesProfile = (RulesProfileDto)rulesProfilesByLanguage.get(qp.getLanguage());
            if (rulesProfile == null) {
                return;
            }
            QProfileDto qualityProfile = this.dbClient.qualityProfileDao().selectByRuleProfileUuid(dbSession, qp.getOrganizationUuid(), rulesProfile.getKee());
            if (qualityProfile == null) {
                return;
            }
            Set uuids = this.dbClient.defaultQProfileDao().selectExistingQProfileUuids(dbSession, qp.getOrganizationUuid(), Collections.singleton(qp.getKee()));
            this.dbClient.defaultQProfileDao().deleteByQProfileUuids(dbSession, (Collection)uuids);
            this.dbClient.defaultQProfileDao().insertOrUpdate(dbSession, new DefaultQProfileDto().setQProfileUuid(qualityProfile.getKee()).setLanguage(qp.getLanguage()).setOrganizationUuid(qp.getOrganizationUuid()));
            LOGGER.info("Default built-in quality profile for language [{}] has been updated from [{}] to [{}] since previous default does not have active rules.", new Object[]{qp.getLanguage(), qp.getName(), rulesProfile.getName()});
        });
        dbSession.commit();
    }

    private /* synthetic */ void lambda$start$1(Map persistedRuleProfiles, DbSession dbSession, DbSession batchDbSession, Multimap changedProfiles, BuiltInQProfile builtIn) {
        RulesProfileDto ruleProfile = (RulesProfileDto)persistedRuleProfiles.get(builtIn.getQProfileName());
        if (ruleProfile == null) {
            this.create(dbSession, batchDbSession, builtIn);
        } else {
            List<ActiveRuleChange> changes = this.update(dbSession, builtIn, ruleProfile);
            changedProfiles.putAll((Object)builtIn.getQProfileName(), (Iterable)changes.stream().filter(change -> {
                String inheritance = change.getActiveRule().getInheritance();
                return inheritance == null || ActiveRuleInheritance.NONE.name().equals(inheritance);
            }).collect(MoreCollectors.toList()));
        }
    }
}

