/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.QProfileBackuper;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class BackupAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final QProfileBackuper backuper;
    private final QProfileWsSupport wsSupport;
    private final Languages languages;

    public BackupAction(DbClient dbClient, QProfileBackuper backuper, QProfileWsSupport wsSupport, Languages languages) {
        this.dbClient = dbClient;
        this.backuper = backuper;
        this.wsSupport = wsSupport;
        this.languages = languages;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("backup").setSince("5.2").setDescription("Backup a quality profile in XML form. The exported profile can be restored through api/qualityprofiles/restore.").setResponseExample(this.getClass().getResource("backup-example.xml")).setHandler((RequestHandler)this);
        QProfileReference.defineParams(action, this.languages);
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
    }

    public void handle(Request request, Response response) throws Exception {
        Response.Stream stream = response.stream();
        stream.setMediaType("application/xml");
        try (OutputStreamWriter writer = new OutputStreamWriter(stream.output(), StandardCharsets.UTF_8);
             DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.wsSupport.getProfile(dbSession, QProfileReference.from(request));
            response.setHeader("Content-Disposition", String.format("attachment; filename=%s.xml", profile.getKee()));
            this.backuper.backup(dbSession, profile, writer);
        }
    }
}

