/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.util.Optional;
import java.util.function.Supplier;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.protobuf.DbFileSources;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.LinesJsonWriter;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class LinesAction
implements SourcesWsAction {
    private static final String PARAM_UUID = "uuid";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_FROM = "from";
    private static final String PARAM_TO = "to";
    private static final String PARAM_BRANCH = "branch";
    private static final String PARAM_PULL_REQUEST = "pullRequest";
    private final ComponentFinder componentFinder;
    private final SourceService sourceService;
    private final LinesJsonWriter linesJsonWriter;
    private final DbClient dbClient;
    private final UserSession userSession;

    public LinesAction(ComponentFinder componentFinder, DbClient dbClient, SourceService sourceService, LinesJsonWriter linesJsonWriter, UserSession userSession) {
        this.componentFinder = componentFinder;
        this.sourceService = sourceService;
        this.linesJsonWriter = linesJsonWriter;
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("lines").setDescription("Show source code with line oriented info. Requires See Source Code permission on file's project<br/>Each element of the result array is an object which contains:<ol><li>Line number</li><li>Content of the line</li><li>Author of the line (from SCM information)</li><li>Revision of the line (from SCM information)</li><li>Last commit date of the line (from SCM information)</li><li>Line hits from coverage</li><li>Number of conditions to cover in tests</li><li>Number of conditions covered by tests</li><li>Whether the line is new</li></ol>").setSince("5.0").setInternal(true).setResponseExample(Resources.getResource(this.getClass(), (String)"lines-example.json")).setChangelog(new Change[]{new Change("6.2", "fields \"utLineHits\", \"utConditions\" and \"utCoveredConditions\" has been renamed \"lineHits\", \"conditions\" and \"coveredConditions\""), new Change("6.2", "fields \"itLineHits\", \"itConditions\" and \"itCoveredConditions\" are no more returned"), new Change("6.6", "field \"branch\" added"), new Change("7.4", "field \"isNew\" added")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_UUID).setDescription("File uuid. Mandatory if param 'key' is not set").setExampleValue((Object)"f333aab4-7e3a-4d70-87e1-f4c491f05e5c");
        action.createParam(PARAM_KEY).setDescription("File key. Mandatory if param 'uuid' is not set. Available since 5.2").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam(PARAM_BRANCH).setDescription("Branch key").setInternal(true).setExampleValue((Object)"feature/my_branch");
        action.createParam(PARAM_PULL_REQUEST).setDescription("Pull request id").setInternal(true).setExampleValue((Object)"5461");
        action.createParam(PARAM_FROM).setDescription("First line to return. Starts from 1").setExampleValue((Object)"10").setDefaultValue((Object)"1");
        action.createParam(PARAM_TO).setDescription("Optional last line to return (inclusive). It must be greater than or equal to parameter 'from'. If unset, then all the lines greater than or equal to 'from' are returned.").setExampleValue((Object)"20");
    }

    public void handle(Request request, Response response) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto file = this.loadComponent(dbSession, request);
            Supplier<Optional<Long>> periodDateSupplier = () -> this.dbClient.snapshotDao().selectLastAnalysisByComponentUuid(dbSession, file.projectUuid()).map(SnapshotDto::getPeriodDate);
            this.userSession.checkComponentPermission("codeviewer", file);
            int from = request.mandatoryParamAsInt(PARAM_FROM);
            int to = (Integer)MoreObjects.firstNonNull((Object)request.paramAsInt(PARAM_TO), (Object)Integer.MAX_VALUE);
            Iterable<DbFileSources.Line> lines = WsUtils.checkFoundWithOptional(this.sourceService.getLines(dbSession, file.uuid(), from, to), "No source found for file '%s'", file.getDbKey());
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                this.linesJsonWriter.writeSource(lines, json, this.isMemberOfOrganization(file), periodDateSupplier);
                json.endObject();
            }
        }
    }

    private boolean isMemberOfOrganization(ComponentDto file) {
        return this.userSession.hasMembership(new OrganizationDto().setUuid(file.getOrganizationUuid()));
    }

    private ComponentDto loadComponent(DbSession dbSession, Request wsRequest) {
        String componentKey = wsRequest.param(PARAM_KEY);
        String componentId = wsRequest.param(PARAM_UUID);
        String branch = wsRequest.param(PARAM_BRANCH);
        String pullRequest = wsRequest.param(PARAM_PULL_REQUEST);
        Preconditions.checkArgument((componentId == null || branch == null && pullRequest == null ? 1 : 0) != 0, (String)"Parameter '%s' cannot be used at the same time as '%s' or '%s'", (Object[])new Object[]{PARAM_UUID, PARAM_BRANCH, PARAM_PULL_REQUEST});
        if (branch == null && pullRequest == null) {
            return this.componentFinder.getByUuidOrKey(dbSession, componentId, componentKey, ComponentFinder.ParamNames.UUID_AND_KEY);
        }
        WsUtils.checkRequest(componentKey != null, "The '%s' parameter is missing", PARAM_KEY);
        return this.componentFinder.getByKeyAndOptionalBranchOrPullRequest(dbSession, componentKey, branch, pullRequest);
    }
}

