/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.source.ws;

import com.google.common.io.Resources;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.source.SourceService;
import org.sonar.server.source.ws.SourcesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class ShowAction
implements SourcesWsAction {
    private final SourceService sourceService;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;

    public ShowAction(SourceService sourceService, DbClient dbClient, UserSession userSession, ComponentFinder componentFinder) {
        this.sourceService = sourceService;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Get source code. Requires See Source Code permission on file's project<br/>Each element of the result array is composed of:<ol><li>Line number</li><li>Content of the line</li></ol>").setSince("4.4").setResponseExample(Resources.getResource(this.getClass(), (String)"example-show.json")).setHandler((RequestHandler)this);
        action.createParam("key").setRequired(true).setDescription("File key").setExampleValue((Object)"my_project:/src/foo/Bar.php");
        action.createParam("from").setDescription("First line to return. Starts at 1").setExampleValue((Object)"10").setDefaultValue((Object)"1");
        action.createParam("to").setDescription("Last line to return (inclusive)").setExampleValue((Object)"20");
    }

    public void handle(Request request, Response response) {
        String fileKey = request.mandatoryParam("key");
        int from = Math.max(request.paramAsInt("from"), 1);
        int to = (Integer)ObjectUtils.defaultIfNull((Object)request.paramAsInt("to"), (Object)Integer.MAX_VALUE);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto file = this.componentFinder.getByKey(dbSession, fileKey);
            this.userSession.checkComponentPermission("codeviewer", file);
            Iterable<String> linesHtml = WsUtils.checkFoundWithOptional(this.sourceService.getLinesAsHtml(dbSession, file.uuid(), from, to), "No source found for file '%s'", fileKey);
            try (JsonWriter json = response.newJsonWriter();){
                json.beginObject();
                ShowAction.writeSource(linesHtml, from, json);
                json.endObject();
            }
        }
    }

    private static void writeSource(Iterable<String> lines, int from, JsonWriter json) {
        json.name("sources").beginArray();
        long index = 0L;
        for (String line : lines) {
            json.beginArray();
            json.value(index + (long)from);
            json.value(line);
            json.endArray();
            ++index;
        }
        json.endArray();
    }
}

