/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import com.google.common.base.Strings;
import org.picocontainer.Startable;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.property.PropertiesDao;

public class RenameDeprecatedPropertyKeys
implements Startable {
    private PropertiesDao dao;
    private PropertyDefinitions definitions;

    public RenameDeprecatedPropertyKeys(PropertiesDao dao, PropertyDefinitions definitions) {
        this.dao = dao;
        this.definitions = definitions;
    }

    public void start() {
        Loggers.get(RenameDeprecatedPropertyKeys.class).info("Rename deprecated property keys");
        for (PropertyDefinition definition : this.definitions.getAll()) {
            if (Strings.isNullOrEmpty((String)definition.deprecatedKey())) continue;
            this.dao.renamePropertyKey(definition.deprecatedKey(), definition.key());
        }
    }

    public void stop() {
    }
}

