/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.utils.MessageException;
import org.sonar.api.web.WebAnalytics;
import org.sonar.server.ui.WebAnalyticsLoader;

public class WebAnalyticsLoaderImpl
implements WebAnalyticsLoader {
    @Nullable
    private final WebAnalytics analytics;

    public WebAnalyticsLoaderImpl(WebAnalytics[] analytics) {
        if (analytics.length > 1) {
            List classes = Arrays.stream(analytics).map(a -> a.getClass().getName()).collect(Collectors.toList());
            throw MessageException.of((String)("Limited to only one web analytics plugin. Found multiple implementations: " + classes));
        }
        this.analytics = analytics.length == 1 ? analytics[0] : null;
    }

    public WebAnalyticsLoaderImpl() {
        this.analytics = null;
    }

    @Override
    public Optional<String> getUrlPathToJs() {
        return Optional.ofNullable(this.analytics).map(WebAnalytics::getUrlPathToJs).filter(path -> !path.startsWith("/") && !path.contains("..") && !path.contains("://")).map(path -> "/" + path);
    }
}

