/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import java.util.Objects;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserPropertyDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.UsersWsAction;

public class SetSettingAction
implements UsersWsAction {
    public static final String PARAM_KEY = "key";
    public static final String PARAM_VALUE = "value";
    private final DbClient dbClient;
    private final UserSession userSession;

    public SetSettingAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("set_setting").setDescription("Update a setting value.<br>Requires user to be authenticated").setSince("7.6").setInternal(true).setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_KEY).setRequired(true).setMaximumLength(Integer.valueOf(100)).setDescription("Setting key").setPossibleValues((Object[])new String[]{"notifications.optOut", "notifications.readDate", "newsbox.dismiss.hotspots"});
        action.createParam(PARAM_VALUE).setRequired(true).setMaximumLength(Integer.valueOf(4000)).setDescription("Setting value").setExampleValue((Object)"true");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String key = request.mandatoryParam(PARAM_KEY);
        String value = request.mandatoryParam(PARAM_VALUE);
        this.setUserSetting(key, value);
        response.noContent();
    }

    private void setUserSetting(String key, String value) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.dbClient.userPropertiesDao().insertOrUpdate(dbSession, new UserPropertyDto().setUserUuid(Objects.requireNonNull(this.userSession.getUuid(), "Authenticated user uuid cannot be null")).setKey(key).setValue(value));
            dbSession.commit();
        }
    }
}

