/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.SonarEdition;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;

public class MetadataLoader {
    private static final String VERSION_FILE_PATH = "/sonar-api-version.txt";
    private static final String EDITION_FILE_PATH = "/sonar-edition.txt";

    private MetadataLoader() {
    }

    public static Version loadVersion(System2 system) {
        try {
            URL url = system.getResource(VERSION_FILE_PATH);
            String versionInFile = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return Version.parse(versionInFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not load /sonar-api-version.txt from classpath", e);
        }
    }

    public static SonarEdition loadEdition(System2 system) {
        try {
            URL url = system.getResource(EDITION_FILE_PATH);
            if (url == null) {
                return SonarEdition.COMMUNITY;
            }
            String editionInFile = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return MetadataLoader.parseEdition(editionInFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can not load /sonar-edition.txt from classpath", e);
        }
    }

    static SonarEdition parseEdition(String edition) {
        String str = StringUtils.trimToEmpty((String)edition.toUpperCase());
        try {
            return SonarEdition.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Invalid edition found in '%s': '%s'", EDITION_FILE_PATH, str));
        }
    }
}

