/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.DotNetPluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProtobufDataImporter;
import org.sonarsource.dotnet.shared.plugins.RealPathProvider;
import org.sonarsource.dotnet.shared.plugins.ReportPathCollector;
import org.sonarsource.dotnet.shared.plugins.RoslynDataImporter;
import org.sonarsource.dotnet.shared.plugins.RoslynProfileExporter;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;

public class DotNetSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(DotNetSensor.class);
    private final ProtobufDataImporter protobufDataImporter;
    private final RoslynDataImporter roslynDataImporter;
    private final DotNetPluginMetadata pluginMetadata;
    private final ReportPathCollector reportPathCollector;

    public DotNetSensor(DotNetPluginMetadata pluginMetadata, ReportPathCollector reportPathCollector, ProtobufDataImporter protobufDataImporter, RoslynDataImporter roslynDataImporter) {
        this.pluginMetadata = pluginMetadata;
        this.reportPathCollector = reportPathCollector;
        this.protobufDataImporter = protobufDataImporter;
        this.roslynDataImporter = roslynDataImporter;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.pluginMetadata.shortLanguageName()).onlyOnLanguage(this.pluginMetadata.languageKey()).global();
    }

    public void execute(SensorContext context) {
        if (this.shouldExecuteOnProject(context.fileSystem())) {
            this.executeInternal(context);
        }
    }

    private boolean shouldExecuteOnProject(FileSystem fs) {
        if (!this.filesToAnalyze(fs).iterator().hasNext()) {
            LOG.debug("No files to analyze. Skip Sensor.");
            return false;
        }
        return true;
    }

    private Iterable<InputFile> filesToAnalyze(FileSystem fs) {
        return fs.inputFiles(fs.predicates().and(fs.predicates().hasType(InputFile.Type.MAIN), fs.predicates().hasLanguage(this.pluginMetadata.languageKey())));
    }

    private void executeInternal(SensorContext context) {
        List<RoslynReport> roslynDirs;
        RealPathProvider toRealPath = new RealPathProvider();
        List<Path> protobufPaths = this.reportPathCollector.protobufDirs();
        if (!protobufPaths.isEmpty()) {
            this.protobufDataImporter.importResults(context, protobufPaths, toRealPath);
        }
        if (!(roslynDirs = this.reportPathCollector.roslynDirs()).isEmpty()) {
            Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(this.pluginMetadata, context.activeRules().findAll().stream().map(ActiveRule::ruleKey).collect(Collectors.toList()));
            this.roslynDataImporter.importRoslynReports(roslynDirs, context, activeRoslynRulesByPartialRepoKey, toRealPath);
        }
    }
}

