/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.JumpTargetInstr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.util.IGVHelper;
import org.jruby.ir.util.IGVInstrListener;

public class IGVCFGVisitor {
    PrintStream writer;
    Map<BasicBlock, Integer> indexOffsets = new HashMap<BasicBlock, Integer>();
    List<Tuple<Integer, Integer>> instrEdges = new ArrayList<Tuple<Integer, Integer>>();
    List<Tuple<Integer, JumpTargetInstr>> extraInstrEdges = new ArrayList<Tuple<Integer, JumpTargetInstr>>();
    Instr lastInstr = null;
    IGVInstrListener listener;

    public IGVCFGVisitor(CFG cfg, PrintStream writer, String name2) {
        this.writer = writer;
        this.listener = (IGVInstrListener)cfg.getScope().getManager().getInstructionsListener();
        this.CFG(cfg, name2);
        this.listener.reset();
    }

    protected void visitBasicBlocks(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            this.BasicBlock(basicBlock);
        }
    }

    protected void visitEdges(CFG cfg) {
        for (BasicBlock basicBlock : cfg.getBasicBlocks()) {
            IGVHelper.startTag((PrintStream)this.writer, (String)"block", (Object[])new Object[]{"name", basicBlock.getLabel()});
            IGVHelper.startTag((PrintStream)this.writer, (String)"successors");
            for (BasicBlock destination : cfg.getOutgoingDestinations(basicBlock)) {
                IGVHelper.emptyTag((PrintStream)this.writer, (String)"successor", (Object[])new Object[]{"name", destination.getLabel()});
            }
            IGVHelper.endTag((PrintStream)this.writer, (String)"successors");
            IGVHelper.startTag((PrintStream)this.writer, (String)"nodes");
            for (Instr instr : basicBlock.getInstrs()) {
                IGVHelper.emptyTag((PrintStream)this.writer, (String)"node", (Object[])new Object[]{"id", System.identityHashCode(instr)});
            }
            for (Instr instr : this.listener.removedList(basicBlock)) {
                IGVHelper.emptyTag((PrintStream)this.writer, (String)"removeNode", (Object[])new Object[]{"id", System.identityHashCode(instr)});
            }
            IGVHelper.endTag((PrintStream)this.writer, (String)"nodes");
            IGVHelper.endTag((PrintStream)this.writer, (String)"block");
        }
    }

    protected void visitInstrs(BasicBlock basicBlock) {
        List<Instr> instrs = basicBlock.getInstrs();
        int size2 = instrs.size();
        if (size2 > 0) {
            int lastIPC = this.Instr(instrs.get(0));
            if (this.lastInstr != null && !(this.lastInstr instanceof JumpInstr)) {
                this.instrEdges.add(new Tuple<Integer, Integer>(System.identityHashCode(this.lastInstr), lastIPC));
            }
            for (int i2 = 1; i2 < size2; ++i2) {
                int ipc = this.Instr(instrs.get(i2));
                this.instrEdges.add(new Tuple<Integer, Integer>(lastIPC, ipc));
                lastIPC = ipc;
            }
            this.lastInstr = instrs.get(size2 - 1);
        }
    }

    public void BasicBlock(BasicBlock basicBlock) {
        if (!basicBlock.getInstrs().isEmpty()) {
            this.indexOffsets.put(basicBlock, System.identityHashCode(basicBlock.getInstrs().get(0)));
        }
        this.visitInstrs(basicBlock);
    }

    public void CFG(CFG cfg, String name2) {
        IGVHelper.startTag((PrintStream)this.writer, (String)"graph");
        IGVHelper.startTag((PrintStream)this.writer, (String)"properties");
        IGVHelper.property((PrintStream)this.writer, (String)"name", (Object)name2);
        IGVHelper.endTag((PrintStream)this.writer, (String)"properties");
        IGVHelper.startTag((PrintStream)this.writer, (String)"nodes");
        this.visitBasicBlocks(cfg);
        IGVHelper.endTag((PrintStream)this.writer, (String)"nodes");
        IGVHelper.startTag((PrintStream)this.writer, (String)"edges");
        for (Tuple<Integer, Integer> tuple : this.instrEdges) {
            IGVHelper.emptyTag((PrintStream)this.writer, (String)"edge", (Object[])new Object[]{"from", tuple.a, "to", tuple.b});
        }
        for (Tuple<Integer, Object> tuple : this.extraInstrEdges) {
            IGVHelper.emptyTag((PrintStream)this.writer, (String)"edge", (Object[])new Object[]{"from", tuple.a, "to", this.indexOffsets.get(cfg.getBBForLabel(((JumpTargetInstr)tuple.b).getJumpTarget()))});
        }
        for (Tuple<Integer, Object> tuple : this.listener.getRemovedEdges()) {
            IGVHelper.emptyTag((PrintStream)this.writer, (String)"removedEdge", (Object[])new Object[]{"from", System.identityHashCode(tuple.a), "to", System.identityHashCode(tuple.b)});
        }
        IGVHelper.endTag((PrintStream)this.writer, (String)"edges");
        IGVHelper.startTag((PrintStream)this.writer, (String)"controlFlow");
        this.visitEdges(cfg);
        IGVHelper.endTag((PrintStream)this.writer, (String)"controlFlow");
        IGVHelper.endTag((PrintStream)this.writer, (String)"graph");
    }

    public int Instr(Instr instr) {
        int ipc = System.identityHashCode(instr);
        IGVHelper.startTag((PrintStream)this.writer, (String)"node", (Object[])new Object[]{"id", ipc});
        IGVHelper.startTag((PrintStream)this.writer, (String)"properties");
        IGVHelper.property((PrintStream)this.writer, (String)"label", (Object)ipc);
        IGVHelper.property((PrintStream)this.writer, (String)"name", (Object)instr);
        if (instr instanceof BranchInstr) {
            this.extraInstrEdges.add(new Tuple<Integer, JumpTargetInstr>(ipc, (JumpTargetInstr)((Object)instr)));
        }
        IGVHelper.endTag((PrintStream)this.writer, (String)"properties");
        IGVHelper.endTag((PrintStream)this.writer, (String)"node");
        return ipc;
    }
}

