/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.StringLiteralTree;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.VariableDeclarationTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;

@Rule(key="S2068")
public class HardcodedCredentialsCheck
implements SlangCheck {
    private static final String DEFAULT_VALUE = "password,passwd,pwd";
    @RuleProperty(key="credentialWords", description="Comma separated list of words identifying potential credentials", defaultValue="password,passwd,pwd")
    public String credentialWords = "password,passwd,pwd";
    private List<Pattern> variablePatterns;
    private List<Pattern> literalPatterns;

    @Override
    public void initialize(InitContext init) {
        init.register(AssignmentExpressionTree.class, (ctx, tree) -> {
            Tree leftHandSide = tree.leftHandSide();
            if (leftHandSide instanceof IdentifierTree && tree.statementOrExpression() instanceof StringLiteralTree) {
                this.getPasswordVariableName(((IdentifierTree)leftHandSide).name()).ifPresent(passwordVariableName -> HardcodedCredentialsCheck.report(ctx, leftHandSide, passwordVariableName));
            }
        });
        init.register(VariableDeclarationTree.class, (ctx, tree) -> {
            if (tree.initializer() instanceof StringLiteralTree) {
                this.getPasswordVariableName(tree.identifier().name()).ifPresent(passwordVariableName -> HardcodedCredentialsCheck.report(ctx, tree.identifier(), passwordVariableName));
            }
        });
        init.register(StringLiteralTree.class, (ctx, tree) -> this.literalPatterns().map(pattern -> pattern.matcher(tree.content())).filter(Matcher::find).map(matcher -> matcher.group(1)).forEach(credential -> HardcodedCredentialsCheck.report(ctx, tree, credential)));
    }

    private static void report(CheckContext ctx, Tree tree, String matchName) {
        String message2 = String.format("\"%s\" detected in this expression, review this potentially hardcoded credential.", matchName);
        ctx.reportIssue(tree, message2);
    }

    private Optional<String> getPasswordVariableName(String name2) {
        return this.variablePatterns().map(pattern -> pattern.matcher(name2)).filter(Matcher::find).map(matcher -> matcher.group(1)).findAny();
    }

    private Stream<Pattern> variablePatterns() {
        if (this.variablePatterns == null) {
            this.variablePatterns = this.toPatterns("");
        }
        return this.variablePatterns.stream();
    }

    private Stream<Pattern> literalPatterns() {
        if (this.literalPatterns == null) {
            this.literalPatterns = this.toPatterns("=\\S");
        }
        return this.literalPatterns.stream();
    }

    private List<Pattern> toPatterns(String suffix) {
        return Stream.of(this.credentialWords.split(",")).map(String::trim).map(word -> Pattern.compile("(" + word + ")" + suffix, 2)).collect(Collectors.toList());
    }
}

