/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.sonar.server.es.EsUtils;

public class StickyFacetBuilder {
    private static final int FACET_DEFAULT_MIN_DOC_COUNT = 1;
    private static final int FACET_DEFAULT_SIZE = 10;
    private static final BucketOrder FACET_DEFAULT_ORDER = BucketOrder.count((boolean)false);
    private static final int MAXIMUM_NUMBER_OF_SELECTED_ITEMS_WHOSE_DOC_COUNT_WILL_BE_CALCULATED = 50;
    private static final Collector<CharSequence, ?, String> PIPE_JOINER = Collectors.joining("|");
    private final QueryBuilder query;
    private final Map<String, QueryBuilder> filters;
    private final AbstractAggregationBuilder subAggregation;
    private final BucketOrder order;

    public StickyFacetBuilder(QueryBuilder query, Map<String, QueryBuilder> filters) {
        this(query, filters, null, FACET_DEFAULT_ORDER);
    }

    public StickyFacetBuilder(QueryBuilder query, Map<String, QueryBuilder> filters, @Nullable AbstractAggregationBuilder subAggregation, @Nullable BucketOrder order) {
        this.query = query;
        this.filters = filters;
        this.subAggregation = subAggregation;
        this.order = order;
    }

    public AggregationBuilder buildStickyFacet(String fieldName, String facetName, Object ... selected) {
        return this.buildStickyFacet(fieldName, facetName, 10, (TermsAggregationBuilder t) -> t, selected);
    }

    public AggregationBuilder buildStickyFacet(String fieldName, String facetName, int size, Object ... selected) {
        return this.buildStickyFacet(fieldName, facetName, size, (TermsAggregationBuilder t) -> t, selected);
    }

    public AggregationBuilder buildStickyFacet(String fieldName, String facetName, int size, Function<TermsAggregationBuilder, AggregationBuilder> additionalAggregationFilter, Object ... selected) {
        BoolQueryBuilder facetFilter = this.getStickyFacetFilter(fieldName);
        FilterAggregationBuilder facetTopAggregation = this.buildTopFacetAggregation(fieldName, facetName, facetFilter, size, additionalAggregationFilter);
        facetTopAggregation = this.addSelectedItemsToFacet(fieldName, facetName, facetTopAggregation, additionalAggregationFilter, selected);
        return AggregationBuilders.global((String)facetName).subAggregation((AggregationBuilder)facetTopAggregation);
    }

    public BoolQueryBuilder getStickyFacetFilter(String ... fieldNames) {
        BoolQueryBuilder facetFilter = QueryBuilders.boolQuery().must(this.query);
        for (Map.Entry<String, QueryBuilder> filter : this.filters.entrySet()) {
            if (filter.getValue() == null || ArrayUtils.contains((Object[])fieldNames, (Object)filter.getKey())) continue;
            facetFilter.must(filter.getValue());
        }
        return facetFilter;
    }

    public FilterAggregationBuilder buildTopFacetAggregation(String fieldName, String facetName, BoolQueryBuilder facetFilter, int size) {
        return this.buildTopFacetAggregation(fieldName, facetName, facetFilter, size, t -> t);
    }

    private FilterAggregationBuilder buildTopFacetAggregation(String fieldName, String facetName, BoolQueryBuilder facetFilter, int size, Function<TermsAggregationBuilder, AggregationBuilder> additionalAggregationFilter) {
        TermsAggregationBuilder termsAggregation = this.buildTermsFacetAggregation(fieldName, facetName, size);
        AggregationBuilder improvedAggregation = additionalAggregationFilter.apply(termsAggregation);
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)(facetName + "_filter"), (QueryBuilder)facetFilter).subAggregation(improvedAggregation);
    }

    private TermsAggregationBuilder buildTermsFacetAggregation(String fieldName, String facetName, int size) {
        TermsAggregationBuilder termsAggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)facetName).field(fieldName)).order(this.order).size(size).minDocCount(1L);
        if (this.subAggregation != null) {
            termsAggregation = (TermsAggregationBuilder)termsAggregation.subAggregation((AggregationBuilder)this.subAggregation);
        }
        return termsAggregation;
    }

    public FilterAggregationBuilder addSelectedItemsToFacet(String fieldName, String facetName, FilterAggregationBuilder facetTopAggregation, Function<TermsAggregationBuilder, AggregationBuilder> additionalAggregationFilter, Object ... selected) {
        if (selected.length <= 0) {
            return facetTopAggregation;
        }
        String includes = Arrays.stream(selected).filter(Objects::nonNull).map(s -> EsUtils.escapeSpecialRegexChars(s.toString())).collect(PIPE_JOINER);
        TermsAggregationBuilder selectedTerms = ((TermsAggregationBuilder)AggregationBuilders.terms((String)(facetName + "_selected")).size(Math.max(50, includes.length())).field(fieldName)).includeExclude(new IncludeExclude(includes, null));
        if (this.subAggregation != null) {
            selectedTerms = (TermsAggregationBuilder)selectedTerms.subAggregation((AggregationBuilder)this.subAggregation);
        }
        AggregationBuilder improvedAggregation = additionalAggregationFilter.apply(selectedTerms);
        facetTopAggregation.subAggregation(improvedAggregation);
        return facetTopAggregation;
    }
}

