/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.core.i18n.I18n;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.ChangesOnMyIssuesNotification;
import org.sonar.server.issue.notification.EmailMessage;
import org.sonar.server.issue.notification.IssueChangesEmailTemplate;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

public class ChangesOnMyIssuesEmailTemplate
extends IssueChangesEmailTemplate {
    private static final String NOTIFICATION_NAME_I18N_KEY = "notification.dispatcher.ChangesOnMyIssue";

    public ChangesOnMyIssuesEmailTemplate(I18n i18n, EmailSettings settings) {
        super(i18n, settings);
    }

    @Override
    @CheckForNull
    public EmailMessage format(Notification notif) {
        if (!(notif instanceof ChangesOnMyIssuesNotification)) {
            return null;
        }
        ChangesOnMyIssuesNotification notification = (ChangesOnMyIssuesNotification)notif;
        if (notification.getChange() instanceof IssuesChangesNotificationBuilder.AnalysisChange) {
            Preconditions.checkState((!notification.getChangedIssues().isEmpty() ? 1 : 0) != 0, (Object)"changedIssues can't be empty");
            return this.formatAnalysisNotification((IssuesChangesNotificationBuilder.Project)notification.getChangedIssues().keySet().iterator().next(), notification);
        }
        return this.formatMultiProject(notification);
    }

    private EmailMessage formatAnalysisNotification(IssuesChangesNotificationBuilder.Project project, ChangesOnMyIssuesNotification notification) {
        return new EmailMessage().setMessageId("changes-on-my-issues/" + project.getKey()).setSubject(ChangesOnMyIssuesEmailTemplate.buildAnalysisSubject(project)).setHtmlMessage(this.buildAnalysisMessage(project, notification));
    }

    private static String buildAnalysisSubject(IssuesChangesNotificationBuilder.Project project) {
        StringBuilder res = new StringBuilder("Analysis has changed some of your issues in ");
        ChangesOnMyIssuesEmailTemplate.toString(res, project);
        return res.toString();
    }

    private String buildAnalysisMessage(IssuesChangesNotificationBuilder.Project project, ChangesOnMyIssuesNotification notification) {
        List openIssues;
        String projectParams = ChangesOnMyIssuesEmailTemplate.toUrlParams(project);
        StringBuilder sb = new StringBuilder();
        ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> s.append("Hi,"));
        ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> s.append("An analysis has updated ").append(ChangesOnMyIssuesEmailTemplate.issuesOrAnIssue(notification.getChangedIssues())).append(" assigned to you:"));
        ListMultimap issuesByNewStatus = (ListMultimap)notification.getChangedIssues().values().stream().collect(MoreCollectors.index(changedIssue -> "CLOSED".equals(changedIssue.getNewStatus()) ? "CLOSED" : "OPEN", t -> t));
        List closedIssues = issuesByNewStatus.get((Object)"CLOSED");
        if (!closedIssues.isEmpty()) {
            ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> s.append("Closed ").append(ChangesOnMyIssuesEmailTemplate.issueOrIssues(closedIssues)).append(":"));
            this.addIssuesByRule(sb, closedIssues, this.projectIssuePageHref(projectParams));
        }
        if (!(openIssues = issuesByNewStatus.get((Object)"OPEN")).isEmpty()) {
            ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> s.append("Open ").append(ChangesOnMyIssuesEmailTemplate.issueOrIssues(openIssues)).append(":"));
            this.addIssuesByRule(sb, openIssues, this.projectIssuePageHref(projectParams));
        }
        this.addFooter(sb, NOTIFICATION_NAME_I18N_KEY);
        return sb.toString();
    }

    private EmailMessage formatMultiProject(ChangesOnMyIssuesNotification notification) {
        IssuesChangesNotificationBuilder.User user = ((IssuesChangesNotificationBuilder.UserChange)notification.getChange()).getUser();
        return new EmailMessage().setFrom(user.getName().orElse(user.getLogin())).setMessageId("changes-on-my-issues").setSubject("A manual update has changed some of your issues").setHtmlMessage(this.buildMultiProjectMessage(notification));
    }

    private String buildMultiProjectMessage(ChangesOnMyIssuesNotification notification) {
        StringBuilder sb = new StringBuilder();
        ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> s.append("Hi,"));
        ChangesOnMyIssuesEmailTemplate.paragraph(sb, s -> {
            SetMultimap<IssuesChangesNotificationBuilder.Project, IssuesChangesNotificationBuilder.ChangedIssue> changedIssues = notification.getChangedIssues();
            s.append("A manual change has updated ").append(ChangesOnMyIssuesEmailTemplate.issuesOrAnIssue(changedIssues)).append(" assigned to you:");
        });
        this.addIssuesByProjectThenRule(sb, notification.getChangedIssues());
        this.addFooter(sb, NOTIFICATION_NAME_I18N_KEY);
        return sb.toString();
    }

    private static String issueOrIssues(Collection<?> collection) {
        if (collection.size() > 1) {
            return "issues";
        }
        return "issue";
    }

    private static String issuesOrAnIssue(SetMultimap<IssuesChangesNotificationBuilder.Project, IssuesChangesNotificationBuilder.ChangedIssue> changedIssues) {
        if (changedIssues.size() > 1) {
            return "issues";
        }
        return "an issue";
    }
}

