/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.IssuesChangesNotification;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

public class IssuesChangesNotificationSerializer {
    private static final String FIELD_ISSUES_COUNT = "issues.count";
    private static final String FIELD_CHANGE_DATE = "change.date";
    private static final String FIELD_CHANGE_AUTHOR_UUID = "change.author.uuid";
    private static final String FIELD_CHANGE_AUTHOR_LOGIN = "change.author.login";
    private static final String FIELD_CHANGE_AUTHOR_NAME = "change.author.name";

    public IssuesChangesNotification serialize(IssuesChangesNotificationBuilder builder) {
        IssuesChangesNotification res = new IssuesChangesNotification();
        IssuesChangesNotificationSerializer.serializeIssueSize(res, builder.getIssues());
        IssuesChangesNotificationSerializer.serializeChange(res, builder.getChange());
        IssuesChangesNotificationSerializer.serializeIssues(res, builder.getIssues());
        IssuesChangesNotificationSerializer.serializeRules(res, builder.getIssues());
        IssuesChangesNotificationSerializer.serializeProjects(res, builder.getIssues());
        return res;
    }

    public IssuesChangesNotificationBuilder from(IssuesChangesNotification notification) {
        int issueCount = IssuesChangesNotificationSerializer.readIssueCount(notification);
        IssuesChangesNotificationBuilder.Change change = IssuesChangesNotificationSerializer.readChange(notification);
        List<Issue> issues = IssuesChangesNotificationSerializer.readIssues(notification, issueCount);
        Map<String, IssuesChangesNotificationBuilder.Project> projects = IssuesChangesNotificationSerializer.readProjects(notification, issues);
        Map<RuleKey, IssuesChangesNotificationBuilder.Rule> rules = IssuesChangesNotificationSerializer.readRules(notification, issues);
        return new IssuesChangesNotificationBuilder(IssuesChangesNotificationSerializer.buildChangedIssues(issues, projects, rules), change);
    }

    private static void serializeIssueSize(IssuesChangesNotification res, Set<IssuesChangesNotificationBuilder.ChangedIssue> issues) {
        res.setFieldValue(FIELD_ISSUES_COUNT, String.valueOf(issues.size()));
    }

    private static int readIssueCount(IssuesChangesNotification notification) {
        String fieldValue = notification.getFieldValue(FIELD_ISSUES_COUNT);
        Preconditions.checkArgument((fieldValue != null ? 1 : 0) != 0, (String)"missing field %s", (Object[])new Object[]{FIELD_ISSUES_COUNT});
        int issueCount = Integer.parseInt(fieldValue);
        Preconditions.checkArgument((issueCount > 0 ? 1 : 0) != 0, (Object)"issue count must be >= 1");
        return issueCount;
    }

    private static Set<IssuesChangesNotificationBuilder.ChangedIssue> buildChangedIssues(List<Issue> issues, Map<String, IssuesChangesNotificationBuilder.Project> projects, Map<RuleKey, IssuesChangesNotificationBuilder.Rule> rules) {
        return (Set)issues.stream().map(issue -> new IssuesChangesNotificationBuilder.ChangedIssue.Builder(((Issue)issue).key).setNewStatus(((Issue)issue).newStatus).setNewResolution(((Issue)issue).newResolution).setAssignee(((Issue)issue).assignee).setRule((IssuesChangesNotificationBuilder.Rule)rules.get(((Issue)issue).ruleKey)).setProject((IssuesChangesNotificationBuilder.Project)projects.get(((Issue)issue).projectUuid)).build()).collect(MoreCollectors.toSet((int)issues.size()));
    }

    private static void serializeIssues(IssuesChangesNotification res, Set<IssuesChangesNotificationBuilder.ChangedIssue> issues) {
        int index = 0;
        for (IssuesChangesNotificationBuilder.ChangedIssue issue : issues) {
            IssuesChangesNotificationSerializer.serializeIssue(res, index, issue);
            ++index;
        }
    }

    private static List<Issue> readIssues(IssuesChangesNotification notification, int issueCount) {
        ArrayList<Issue> res = new ArrayList<Issue>(issueCount);
        for (int i = 0; i < issueCount; ++i) {
            res.add(IssuesChangesNotificationSerializer.readIssue(notification, i));
        }
        return res;
    }

    private static void serializeIssue(IssuesChangesNotification notification, int index, IssuesChangesNotificationBuilder.ChangedIssue issue) {
        String issuePropertyPrefix = "issues." + index;
        notification.setFieldValue(issuePropertyPrefix + ".key", issue.getKey());
        issue.getAssignee().ifPresent(assignee -> {
            notification.setFieldValue(issuePropertyPrefix + ".assignee.uuid", assignee.getUuid());
            notification.setFieldValue(issuePropertyPrefix + ".assignee.login", assignee.getLogin());
            assignee.getName().ifPresent(name -> notification.setFieldValue(issuePropertyPrefix + ".assignee.name", (String)name));
        });
        issue.getNewResolution().ifPresent(newResolution -> notification.setFieldValue(issuePropertyPrefix + ".newResolution", (String)newResolution));
        notification.setFieldValue(issuePropertyPrefix + ".newStatus", issue.getNewStatus());
        notification.setFieldValue(issuePropertyPrefix + ".ruleKey", issue.getRule().getKey().toString());
        notification.setFieldValue(issuePropertyPrefix + ".projectUuid", issue.getProject().getUuid());
    }

    private static Issue readIssue(IssuesChangesNotification notification, int index) {
        String issuePropertyPrefix = "issues." + index;
        IssuesChangesNotificationBuilder.User assignee = IssuesChangesNotificationSerializer.readAssignee(notification, issuePropertyPrefix, index);
        return new Issue.Builder().setKey(IssuesChangesNotificationSerializer.getIssueFieldValue(notification, issuePropertyPrefix + ".key", index)).setNewStatus(IssuesChangesNotificationSerializer.getIssueFieldValue(notification, issuePropertyPrefix + ".newStatus", index)).setNewResolution(notification.getFieldValue(issuePropertyPrefix + ".newResolution")).setAssignee(assignee).setRuleKey(IssuesChangesNotificationSerializer.getIssueFieldValue(notification, issuePropertyPrefix + ".ruleKey", index)).setProjectUuid(IssuesChangesNotificationSerializer.getIssueFieldValue(notification, issuePropertyPrefix + ".projectUuid", index)).build();
    }

    @CheckForNull
    private static IssuesChangesNotificationBuilder.User readAssignee(IssuesChangesNotification notification, String issuePropertyPrefix, int index) {
        String uuid = notification.getFieldValue(issuePropertyPrefix + ".assignee.uuid");
        if (uuid == null) {
            return null;
        }
        String login = IssuesChangesNotificationSerializer.getIssueFieldValue(notification, issuePropertyPrefix + ".assignee.login", index);
        return new IssuesChangesNotificationBuilder.User(uuid, login, notification.getFieldValue(issuePropertyPrefix + ".assignee.name"));
    }

    private static String getIssueFieldValue(IssuesChangesNotification notification, String fieldName, int index) {
        String fieldValue = notification.getFieldValue(fieldName);
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (String)"Can not find field %s for issue with index %s", (Object[])new Object[]{fieldName, index});
        return fieldValue;
    }

    private static void serializeRules(IssuesChangesNotification res, Set<IssuesChangesNotificationBuilder.ChangedIssue> issues) {
        issues.stream().map(IssuesChangesNotificationBuilder.ChangedIssue::getRule).collect(Collectors.toSet()).forEach(rule -> res.setFieldValue("rules." + rule.getKey(), rule.getName()));
    }

    private static Map<RuleKey, IssuesChangesNotificationBuilder.Rule> readRules(IssuesChangesNotification notification, List<Issue> issues) {
        return (Map)issues.stream().map(issue -> ((Issue)issue).ruleKey).collect(Collectors.toSet()).stream().map(ruleKey -> IssuesChangesNotificationSerializer.readRule(notification, ruleKey)).collect(MoreCollectors.uniqueIndex(IssuesChangesNotificationBuilder.Rule::getKey, t -> t));
    }

    private static IssuesChangesNotificationBuilder.Rule readRule(IssuesChangesNotification notification, RuleKey ruleKey) {
        String fieldName = "rules." + ruleKey;
        String ruleName = notification.getFieldValue(fieldName);
        Preconditions.checkState((ruleName != null ? 1 : 0) != 0, (String)"can not find field %s", (Object[])new Object[]{ruleKey});
        return new IssuesChangesNotificationBuilder.Rule(ruleKey, ruleName);
    }

    private static void serializeProjects(IssuesChangesNotification res, Set<IssuesChangesNotificationBuilder.ChangedIssue> issues) {
        issues.stream().map(IssuesChangesNotificationBuilder.ChangedIssue::getProject).collect(Collectors.toSet()).forEach(project -> {
            String projectPropertyPrefix = "projects." + project.getUuid();
            res.setFieldValue(projectPropertyPrefix + ".key", project.getKey());
            res.setFieldValue(projectPropertyPrefix + ".projectName", project.getProjectName());
            project.getBranchName().ifPresent(branchName -> res.setFieldValue(projectPropertyPrefix + ".branchName", (String)branchName));
        });
    }

    private static Map<String, IssuesChangesNotificationBuilder.Project> readProjects(IssuesChangesNotification notification, List<Issue> issues) {
        return (Map)issues.stream().map(issue -> ((Issue)issue).projectUuid).collect(Collectors.toSet()).stream().map(projectUuid -> {
            String projectPropertyPrefix = "projects." + projectUuid;
            return new IssuesChangesNotificationBuilder.Project.Builder((String)projectUuid).setKey(IssuesChangesNotificationSerializer.getProjectFieldValue(notification, projectPropertyPrefix + ".key", projectUuid)).setProjectName(IssuesChangesNotificationSerializer.getProjectFieldValue(notification, projectPropertyPrefix + ".projectName", projectUuid)).setBranchName(notification.getFieldValue(projectPropertyPrefix + ".branchName")).build();
        }).collect(MoreCollectors.uniqueIndex(IssuesChangesNotificationBuilder.Project::getUuid, t -> t));
    }

    private static String getProjectFieldValue(IssuesChangesNotification notification, String fieldName, String uuid) {
        String fieldValue = notification.getFieldValue(fieldName);
        Preconditions.checkState((fieldValue != null ? 1 : 0) != 0, (String)"Can not find field %s for project with uuid %s", (Object[])new Object[]{fieldName, uuid});
        return fieldValue;
    }

    private static void serializeChange(IssuesChangesNotification notification, IssuesChangesNotificationBuilder.Change change) {
        notification.setFieldValue(FIELD_CHANGE_DATE, String.valueOf(change.date));
        if (change instanceof IssuesChangesNotificationBuilder.UserChange) {
            IssuesChangesNotificationBuilder.UserChange userChange = (IssuesChangesNotificationBuilder.UserChange)change;
            IssuesChangesNotificationBuilder.User user = userChange.getUser();
            notification.setFieldValue(FIELD_CHANGE_AUTHOR_UUID, user.getUuid());
            notification.setFieldValue(FIELD_CHANGE_AUTHOR_LOGIN, user.getLogin());
            user.getName().ifPresent(name -> notification.setFieldValue(FIELD_CHANGE_AUTHOR_NAME, (String)name));
        }
    }

    private static IssuesChangesNotificationBuilder.Change readChange(IssuesChangesNotification notification) {
        String dateFieldValue = notification.getFieldValue(FIELD_CHANGE_DATE);
        Preconditions.checkState((dateFieldValue != null ? 1 : 0) != 0, (String)"Can not find field %s", (Object[])new Object[]{FIELD_CHANGE_DATE});
        long date = Long.parseLong(dateFieldValue);
        String uuid = notification.getFieldValue(FIELD_CHANGE_AUTHOR_UUID);
        if (uuid == null) {
            return new IssuesChangesNotificationBuilder.AnalysisChange(date);
        }
        String login = notification.getFieldValue(FIELD_CHANGE_AUTHOR_LOGIN);
        Preconditions.checkState((login != null ? 1 : 0) != 0, (String)"Can not find field %s", (Object[])new Object[]{FIELD_CHANGE_AUTHOR_LOGIN});
        return new IssuesChangesNotificationBuilder.UserChange(date, new IssuesChangesNotificationBuilder.User(uuid, login, notification.getFieldValue(FIELD_CHANGE_AUTHOR_NAME)));
    }

    @Immutable
    private static final class Issue {
        private final String key;
        private final String newStatus;
        @CheckForNull
        private final String newResolution;
        @CheckForNull
        private final IssuesChangesNotificationBuilder.User assignee;
        private final RuleKey ruleKey;
        private final String projectUuid;

        private Issue(Builder builder) {
            this.key = builder.key;
            this.newResolution = builder.newResolution;
            this.newStatus = builder.newStatus;
            this.assignee = builder.assignee;
            this.ruleKey = RuleKey.parse((String)builder.ruleKey);
            this.projectUuid = builder.projectUuid;
        }

        static class Builder {
            private String key = null;
            private String newStatus = null;
            @CheckForNull
            private String newResolution = null;
            @CheckForNull
            private IssuesChangesNotificationBuilder.User assignee = null;
            private String ruleKey = null;
            private String projectUuid = null;

            Builder() {
            }

            public Builder setKey(String key) {
                this.key = key;
                return this;
            }

            public Builder setNewStatus(String newStatus) {
                this.newStatus = newStatus;
                return this;
            }

            public Builder setNewResolution(@Nullable String newResolution) {
                this.newResolution = newResolution;
                return this;
            }

            public Builder setAssignee(@Nullable IssuesChangesNotificationBuilder.User assignee) {
                this.assignee = assignee;
                return this;
            }

            public Builder setRuleKey(String ruleKey) {
                this.ruleKey = ruleKey;
                return this;
            }

            public Builder setProjectUuid(String projectUuid) {
                this.projectUuid = projectUuid;
                return this;
            }

            public Issue build() {
                return new Issue(this);
            }
        }
    }
}

