/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.Date;
import org.sonar.api.config.EmailSettings;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.i18n.I18n;
import org.sonar.server.issue.notification.AbstractNewIssuesEmailTemplate;
import org.sonar.server.issue.notification.NewIssuesStatistics;

public class MyNewIssuesEmailTemplate
extends AbstractNewIssuesEmailTemplate {
    public MyNewIssuesEmailTemplate(EmailSettings settings, I18n i18n) {
        super(settings, i18n);
    }

    @Override
    protected boolean shouldNotFormat(Notification notification) {
        return !"my-new-issues".equals(notification.getType());
    }

    @Override
    protected void appendAssignees(StringBuilder message, Notification notification) {
    }

    @Override
    protected String subject(Notification notification, String fullProjectName) {
        int issueCount = Integer.parseInt(notification.getFieldValue((Object)((Object)NewIssuesStatistics.Metric.RULE_TYPE) + ".count"));
        return String.format("You have %s new issue%s on project %s", issueCount, issueCount > 1 ? "s" : "", fullProjectName);
    }

    @Override
    protected void appendFooter(StringBuilder message, Notification notification) {
        String projectKey = notification.getFieldValue("projectKey");
        String dateString = notification.getFieldValue("projectDate");
        String assignee = notification.getFieldValue("assignee");
        if (projectKey != null && dateString != null && assignee != null) {
            String pullRequest;
            Date date = DateUtils.parseDateTime((String)dateString);
            String url = String.format("%s/project/issues?id=%s&assignees=%s", this.settings.getServerBaseURL(), MyNewIssuesEmailTemplate.encode(projectKey), MyNewIssuesEmailTemplate.encode(assignee));
            String branchName = notification.getFieldValue("branch");
            if (branchName != null) {
                url = url + "&branch=" + MyNewIssuesEmailTemplate.encode(branchName);
            }
            if ((pullRequest = notification.getFieldValue("pullRequest")) != null) {
                url = url + "&pullRequest=" + MyNewIssuesEmailTemplate.encode(pullRequest);
            }
            url = url + "&createdAt=" + MyNewIssuesEmailTemplate.encode(DateUtils.formatDateTime((Date)date));
            message.append("More details at: ").append(url).append('\n');
        }
    }
}

