/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

final class NotificationWithProjectKeys {
    private final IssuesChangesNotificationBuilder builder;
    private final Set<String> projectKeys;

    protected NotificationWithProjectKeys(IssuesChangesNotificationBuilder builder) {
        this.builder = builder;
        this.projectKeys = builder.getIssues().stream().map(t -> t.getProject().getKey()).collect(Collectors.toSet());
    }

    public Set<IssuesChangesNotificationBuilder.ChangedIssue> getIssues() {
        return this.builder.getIssues();
    }

    public IssuesChangesNotificationBuilder.Change getChange() {
        return this.builder.getChange();
    }

    public Set<String> getProjectKeys() {
        return this.projectKeys;
    }
}

