/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InvalidClassException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.EmailSubscriberDto;
import org.sonar.db.notification.NotificationQueueDto;
import org.sonar.db.property.Subscriber;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class DefaultNotificationManager
implements NotificationManager {
    private static final Logger LOG = Loggers.get(DefaultNotificationManager.class);
    private static final String UNABLE_TO_READ_NOTIFICATION = "Unable to read notification";
    private NotificationChannel[] notificationChannels;
    private final DbClient dbClient;
    private boolean alreadyLoggedDeserializationIssue = false;

    public DefaultNotificationManager(NotificationChannel[] channels, DbClient dbClient) {
        this.notificationChannels = channels;
        this.dbClient = dbClient;
    }

    @Override
    public <T extends Notification> void scheduleForSending(T notification) {
        NotificationQueueDto dto = NotificationQueueDto.toNotificationQueueDto(notification);
        this.dbClient.notificationQueueDao().insert(Collections.singletonList(dto));
    }

    public <T extends Notification> T getFromQueue() {
        int batchSize = 1;
        List notificationDtos = this.dbClient.notificationQueueDao().selectOldest(batchSize);
        if (notificationDtos.isEmpty()) {
            return null;
        }
        this.dbClient.notificationQueueDao().delete(notificationDtos);
        return this.convertToNotification(notificationDtos);
    }

    private <T extends Notification> T convertToNotification(List<NotificationQueueDto> notifications) {
        try {
            return (T)notifications.get(0).toNotification();
        }
        catch (InvalidClassException e) {
            if (!this.alreadyLoggedDeserializationIssue) {
                this.logDeserializationIssue();
                this.alreadyLoggedDeserializationIssue = true;
            }
            return null;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SonarException(UNABLE_TO_READ_NOTIFICATION, (Throwable)e);
        }
    }

    @VisibleForTesting
    void logDeserializationIssue() {
        LOG.warn("It is impossible to send pending notifications which existed prior to the upgrade of SonarQube. They will be ignored.");
    }

    public long count() {
        return this.dbClient.notificationQueueDao().count();
    }

    @Override
    public Multimap<String, NotificationChannel> findSubscribedRecipientsForDispatcher(NotificationDispatcher dispatcher, String projectKey, NotificationManager.SubscriberPermissionsOnProject subscriberPermissionsOnProject) {
        DefaultNotificationManager.verifyProjectKey(projectKey);
        String dispatcherKey = dispatcher.getKey();
        Set<SubscriberAndChannel> subscriberAndChannels = Arrays.stream(this.notificationChannels).flatMap(notificationChannel -> this.toSubscriberAndChannels(dispatcherKey, projectKey, (NotificationChannel)notificationChannel)).collect(Collectors.toSet());
        if (subscriberAndChannels.isEmpty()) {
            return ImmutableMultimap.of();
        }
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set<String> authorizedLogins = this.keepAuthorizedLogins(dbSession, projectKey, subscriberAndChannels, subscriberPermissionsOnProject);
            subscriberAndChannels.stream().filter(subscriberAndChannel -> authorizedLogins.contains(subscriberAndChannel.getSubscriber().getLogin())).forEach(subscriberAndChannel -> builder.put((Object)subscriberAndChannel.getSubscriber().getLogin(), (Object)subscriberAndChannel.getChannel()));
        }
        return builder.build();
    }

    private static void verifyProjectKey(String projectKey) {
        Objects.requireNonNull(projectKey, "projectKey is mandatory");
    }

    private Stream<SubscriberAndChannel> toSubscriberAndChannels(String dispatcherKey, String projectKey, NotificationChannel notificationChannel) {
        Set usersForNotification = this.dbClient.propertiesDao().findUsersForNotification(dispatcherKey, notificationChannel.getKey(), projectKey);
        return usersForNotification.stream().map(login -> new SubscriberAndChannel((Subscriber)login, notificationChannel));
    }

    private Set<String> keepAuthorizedLogins(DbSession dbSession, String projectKey, Set<SubscriberAndChannel> subscriberAndChannels, NotificationManager.SubscriberPermissionsOnProject requiredPermissions) {
        if (requiredPermissions.getGlobalSubscribers().equals(requiredPermissions.getProjectSubscribers())) {
            return this.keepAuthorizedLogins(dbSession, projectKey, subscriberAndChannels, null, requiredPermissions.getGlobalSubscribers());
        }
        return Stream.concat(this.keepAuthorizedLogins(dbSession, projectKey, subscriberAndChannels, true, requiredPermissions.getGlobalSubscribers()).stream(), this.keepAuthorizedLogins(dbSession, projectKey, subscriberAndChannels, false, requiredPermissions.getProjectSubscribers()).stream()).collect(Collectors.toSet());
    }

    private Set<String> keepAuthorizedLogins(DbSession dbSession, String projectKey, Set<SubscriberAndChannel> subscriberAndChannels, @Nullable Boolean global, String permission) {
        Set logins = subscriberAndChannels.stream().filter(s -> global == null || s.getSubscriber().isGlobal() == global.booleanValue()).map(s -> s.getSubscriber().getLogin()).collect(Collectors.toSet());
        if (logins.isEmpty()) {
            return Collections.emptySet();
        }
        return this.dbClient.authorizationDao().keepAuthorizedLoginsOnProject(dbSession, logins, projectKey, permission);
    }

    @Override
    public Set<NotificationManager.EmailRecipient> findSubscribedEmailRecipients(String dispatcherKey, String projectKey, NotificationManager.SubscriberPermissionsOnProject subscriberPermissionsOnProject) {
        DefaultNotificationManager.verifyProjectKey(projectKey);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set emailSubscribers = this.dbClient.propertiesDao().findEmailSubscribersForNotification(dbSession, dispatcherKey, EmailNotificationChannel.class.getSimpleName(), projectKey);
            Set<NotificationManager.EmailRecipient> set = this.keepAuthorizedEmailSubscribers(dbSession, projectKey, subscriberPermissionsOnProject, emailSubscribers);
            return set;
        }
    }

    @Override
    public Set<NotificationManager.EmailRecipient> findSubscribedEmailRecipients(String dispatcherKey, String projectKey, Set<String> logins, NotificationManager.SubscriberPermissionsOnProject subscriberPermissionsOnProject) {
        DefaultNotificationManager.verifyProjectKey(projectKey);
        Objects.requireNonNull(logins, "logins can't be null");
        if (logins.isEmpty()) {
            return Collections.emptySet();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Set emailSubscribers = this.dbClient.propertiesDao().findEmailSubscribersForNotification(dbSession, dispatcherKey, EmailNotificationChannel.class.getSimpleName(), projectKey, logins);
            Set<NotificationManager.EmailRecipient> set = this.keepAuthorizedEmailSubscribers(dbSession, projectKey, subscriberPermissionsOnProject, emailSubscribers);
            return set;
        }
    }

    private Set<NotificationManager.EmailRecipient> keepAuthorizedEmailSubscribers(DbSession dbSession, String projectKey, NotificationManager.SubscriberPermissionsOnProject subscriberPermissionsOnProject, Set<EmailSubscriberDto> emailSubscribers) {
        if (emailSubscribers.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)this.keepAuthorizedEmailSubscribers(dbSession, projectKey, emailSubscribers, subscriberPermissionsOnProject).map(emailSubscriber -> new NotificationManager.EmailRecipient(emailSubscriber.getLogin(), emailSubscriber.getEmail())).collect(MoreCollectors.toSet());
    }

    private Stream<EmailSubscriberDto> keepAuthorizedEmailSubscribers(DbSession dbSession, String projectKey, Set<EmailSubscriberDto> emailSubscribers, NotificationManager.SubscriberPermissionsOnProject requiredPermissions) {
        if (requiredPermissions.getGlobalSubscribers().equals(requiredPermissions.getProjectSubscribers())) {
            return this.keepAuthorizedEmailSubscribers(dbSession, projectKey, emailSubscribers, null, requiredPermissions.getGlobalSubscribers());
        }
        return Stream.concat(this.keepAuthorizedEmailSubscribers(dbSession, projectKey, emailSubscribers, true, requiredPermissions.getGlobalSubscribers()), this.keepAuthorizedEmailSubscribers(dbSession, projectKey, emailSubscribers, false, requiredPermissions.getProjectSubscribers()));
    }

    private Stream<EmailSubscriberDto> keepAuthorizedEmailSubscribers(DbSession dbSession, String projectKey, Set<EmailSubscriberDto> emailSubscribers, @Nullable Boolean global, String permission) {
        Set subscribers = emailSubscribers.stream().filter(s -> global == null || s.isGlobal() == global.booleanValue()).collect(Collectors.toSet());
        if (subscribers.isEmpty()) {
            return Stream.empty();
        }
        Set logins = subscribers.stream().map(EmailSubscriberDto::getLogin).collect(Collectors.toSet());
        Set authorizedLogins = this.dbClient.authorizationDao().keepAuthorizedLoginsOnProject(dbSession, logins, projectKey, permission);
        return subscribers.stream().filter(s -> authorizedLogins.contains(s.getLogin()));
    }

    @VisibleForTesting
    protected List<NotificationChannel> getChannels() {
        return Arrays.asList(this.notificationChannels);
    }

    private static final class SubscriberAndChannel {
        private final Subscriber subscriber;
        private final NotificationChannel channel;

        private SubscriberAndChannel(Subscriber subscriber, NotificationChannel channel) {
            this.subscriber = subscriber;
            this.channel = channel;
        }

        Subscriber getSubscriber() {
            return this.subscriber;
        }

        NotificationChannel getChannel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubscriberAndChannel that = (SubscriberAndChannel)o;
            return Objects.equals(this.subscriber, that.subscriber) && Objects.equals(this.channel, that.channel);
        }

        public int hashCode() {
            return Objects.hash(this.subscriber, this.channel);
        }
    }
}

