/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.setting.SettingLoader;

public class DatabaseSettingLoader
implements SettingLoader {
    private final DbClient dbClient;

    public DatabaseSettingLoader(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public String load(String key) {
        PropertyDto dto = this.dbClient.propertiesDao().selectGlobalProperty(key);
        if (dto != null) {
            return StringUtils.defaultString((String)dto.getValue());
        }
        return null;
    }

    @Override
    public Map<String, String> loadAll() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map map = (Map)this.dbClient.propertiesDao().selectGlobalProperties(dbSession).stream().collect(MoreCollectors.uniqueIndex(PropertyDto::getKey, p -> StringUtils.defaultString((String)p.getValue())));
            return map;
        }
    }
}

