/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class Analysis {
    private final String uuid;
    private final long date;
    @Nullable
    private final String revision;

    public Analysis(String uuid, long date, @Nullable String revision) {
        this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
        this.date = date;
        this.revision = revision;
    }

    public String getUuid() {
        return this.uuid;
    }

    public long getDate() {
        return this.date;
    }

    public Optional<String> getRevision() {
        return Optional.ofNullable(this.revision);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Analysis analysis = (Analysis)o;
        return this.date == analysis.date && this.uuid.equals(analysis.uuid) && Objects.equals(this.revision, analysis.revision);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.date, this.revision);
    }

    public String toString() {
        return "Analysis{uuid='" + this.uuid + '\'' + ", date=" + this.date + ", revision=" + this.revision + '}';
    }
}

