/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.comments;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.checks.comments.CommentUtils;
import org.sonar.plugins.html.node.CommentNode;

@Rule(key="S1134")
public class FixmeCommentCheck
extends AbstractPageCheck {
    private static final Pattern FIXME_PATTERN = Pattern.compile("(?i)(^|[^\\p{L}])(fixme)");

    @Override
    public void comment(CommentNode node) {
        Matcher matcher = FIXME_PATTERN.matcher(node.getCode());
        if (matcher.find()) {
            int lineNumber = CommentUtils.lineNumber(node, matcher.start(2));
            this.createViolation(lineNumber, "Take the required action to fix the issue indicated by this \"FIXME\" comment.");
        }
    }
}

