/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S1436")
public class ElementWithGivenIdPresentCheck
extends AbstractPageCheck {
    @RuleProperty(key="id", description="Value of the \"id\" attribute expected to be present on every page")
    public String id = "";
    private boolean foundId;

    @Override
    public void startDocument(List<Node> nodes) {
        this.foundId = false;
    }

    @Override
    public void startElement(TagNode node) {
        if (this.id.equals(node.getPropertyValue("id"))) {
            this.foundId = true;
        }
    }

    @Override
    public void endDocument() {
        if (!this.id.isEmpty() && !this.foundId) {
            this.createViolation(0, "The ID \"" + this.id + "\" is missing from this page and should be added.");
        }
    }
}

