/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.sql;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.db.dialect.Dialect;
import org.sonar.server.platform.db.migration.def.ColumnDef;
import org.sonar.server.platform.db.migration.def.Validations;

public class AddColumnsBuilder {
    private final Dialect dialect;
    private final String tableName;
    private List<ColumnDef> columnDefs = Lists.newArrayList();

    public AddColumnsBuilder(Dialect dialect, String tableName) {
        this.tableName = Validations.validateTableName(tableName);
        this.dialect = dialect;
    }

    public AddColumnsBuilder addColumn(ColumnDef columnDef) {
        this.columnDefs.add(columnDef);
        return this;
    }

    public String build() {
        if (this.columnDefs.isEmpty()) {
            throw new IllegalStateException("No column has been defined");
        }
        StringBuilder sql = new StringBuilder().append("ALTER TABLE ").append(this.tableName).append(" ");
        switch (this.dialect.getId()) {
            case "postgresql": {
                this.addColumns(sql, "ADD COLUMN ");
                break;
            }
            case "mssql": {
                sql.append("ADD ");
                this.addColumns(sql, "");
                break;
            }
            default: {
                sql.append("ADD (");
                this.addColumns(sql, "");
                sql.append(")");
            }
        }
        return sql.toString();
    }

    private void addColumns(StringBuilder sql, String columnPrefix) {
        for (int i = 0; i < this.columnDefs.size(); ++i) {
            sql.append(columnPrefix);
            this.addColumn(sql, this.columnDefs.get(i));
            if (i >= this.columnDefs.size() - 1) continue;
            sql.append(", ");
        }
    }

    private void addColumn(StringBuilder sql, ColumnDef columnDef) {
        sql.append(columnDef.getName()).append(" ").append(columnDef.generateSqlType(this.dialect));
        Object defaultValue = columnDef.getDefaultValue();
        if (defaultValue != null) {
            sql.append(" DEFAULT ");
            if (defaultValue instanceof String) {
                sql.append(String.format("'%s'", defaultValue));
            } else if (defaultValue instanceof Boolean) {
                sql.append((Boolean)defaultValue != false ? this.dialect.getTrueSqlValue() : this.dialect.getFalseSqlValue());
            } else {
                sql.append(defaultValue);
            }
        }
        sql.append(columnDef.isNullable() ? " NULL" : " NOT NULL");
    }
}

