/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version;

import java.util.Optional;
import org.sonar.server.platform.db.migration.history.MigrationHistory;
import org.sonar.server.platform.db.migration.step.MigrationSteps;

public class DatabaseVersion {
    public static final long MIN_UPGRADE_VERSION = 1830L;
    private final MigrationSteps migrationSteps;
    private final MigrationHistory migrationHistory;

    public DatabaseVersion(MigrationSteps migrationSteps, MigrationHistory migrationHistory) {
        this.migrationSteps = migrationSteps;
        this.migrationHistory = migrationHistory;
    }

    public Status getStatus() {
        return DatabaseVersion.getStatus(this.migrationHistory.getLastMigrationNumber(), this.migrationSteps.getMaxMigrationNumber());
    }

    public Optional<Long> getVersion() {
        return this.migrationHistory.getLastMigrationNumber();
    }

    private static Status getStatus(Optional<Long> currentVersion, long lastVersion) {
        if (!currentVersion.isPresent()) {
            return Status.FRESH_INSTALL;
        }
        Long aLong = currentVersion.get();
        if (aLong == lastVersion) {
            return Status.UP_TO_DATE;
        }
        if (aLong > lastVersion) {
            return Status.REQUIRES_DOWNGRADE;
        }
        return Status.REQUIRES_UPGRADE;
    }

    public static enum Status {
        UP_TO_DATE,
        REQUIRES_UPGRADE,
        REQUIRES_DOWNGRADE,
        FRESH_INSTALL;

    }
}

