/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.db.migration.version.v79;

import java.sql.SQLException;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.SupportsBlueGreen;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

@SupportsBlueGreen
public class MigrateVstsProviderToAzureDevOps
extends DataChange {
    private static final String VSTS = "VSTS";
    private static final String VSTS_TFS = "VSTS / TFS";

    public MigrateVstsProviderToAzureDevOps(Database db) {
        super(db);
    }

    @Override
    protected void execute(DataChange.Context context) throws SQLException {
        MassUpdate massUpdate = context.prepareMassUpdate();
        massUpdate.select("select id, text_value from properties  where prop_key = 'sonar.pullrequest.provider' and text_value in ('VSTS', 'VSTS / TFS')");
        massUpdate.update("update properties  set text_value= ?,  clob_value = null  where id = ?");
        massUpdate.rowPluralName("PR provider properties");
        massUpdate.execute((Select.Row row, SqlStatement update) -> {
            update.setString(1, MigrateVstsProviderToAzureDevOps.convert(row.getString(2)));
            update.setLong(2, row.getLong(1));
            return true;
        });
    }

    private static String convert(String oldValue) {
        switch (oldValue) {
            case "VSTS": {
                return "Azure DevOps Services";
            }
            case "VSTS / TFS": {
                return "Azure DevOps";
            }
        }
        throw new IllegalStateException("Unexpected value: " + oldValue);
    }
}

