/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentMapper;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.GroupPermissionMapper;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.user.GroupMapper;

public class GroupPermissionDao
implements Dao {
    private static final String ANYONE_GROUP_PARAMETER = "anyoneGroup";

    public List<String> selectGroupNamesByQuery(DbSession dbSession, PermissionQuery query) {
        return GroupPermissionDao.mapper(dbSession).selectGroupNamesByQuery(query, new RowBounds(query.getPageOffset(), query.getPageSize()));
    }

    public int countGroupsByQuery(DbSession dbSession, PermissionQuery query) {
        return GroupPermissionDao.mapper(dbSession).countGroupsByQuery(query);
    }

    public List<GroupPermissionDto> selectByGroupIds(DbSession dbSession, String organizationUuid, List<Integer> groupIds, @Nullable Long projectId) {
        return DatabaseUtils.executeLargeInputs(groupIds, groups -> GroupPermissionDao.mapper(dbSession).selectByGroupIds(organizationUuid, (List<Integer>)groups, projectId));
    }

    public void selectAllPermissionsByGroupId(DbSession dbSession, String organizationUuid, Integer groupId, ResultHandler resultHandler) {
        GroupPermissionDao.mapper(dbSession).selectAllPermissionsByGroupId(organizationUuid, groupId, resultHandler);
    }

    public void groupsCountByComponentIdAndPermission(DbSession dbSession, List<Long> componentIds, ResultHandler resultHandler) {
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put(ANYONE_GROUP_PARAMETER, "Anyone");
        DatabaseUtils.executeLargeInputsWithoutOutput(componentIds, partitionedComponentIds -> {
            parameters.put("componentIds", (String)partitionedComponentIds);
            GroupPermissionDao.mapper(dbSession).groupsCountByProjectIdAndPermission(parameters, resultHandler);
        });
    }

    public List<String> selectGlobalPermissionsOfGroup(DbSession session, String organizationUuid, @Nullable Integer groupId) {
        return GroupPermissionDao.mapper(session).selectGlobalPermissionsOfGroup(organizationUuid, groupId);
    }

    public List<String> selectProjectPermissionsOfGroup(DbSession session, String organizationUuid, @Nullable Integer groupId, long projectId) {
        return GroupPermissionDao.mapper(session).selectProjectPermissionsOfGroup(organizationUuid, groupId, projectId);
    }

    public Set<Integer> selectGroupIdsWithPermissionOnProjectBut(DbSession session, long projectId, String permission) {
        return GroupPermissionDao.mapper(session).selectGroupIdsWithPermissionOnProjectBut(projectId, permission);
    }

    public void insert(DbSession dbSession, GroupPermissionDto dto) {
        GroupPermissionDao.ensureComponentPermissionConsistency(dbSession, dto);
        GroupPermissionDao.ensureGroupPermissionConsistency(dbSession, dto);
        GroupPermissionDao.mapper(dbSession).insert(dto);
    }

    private static void ensureComponentPermissionConsistency(DbSession dbSession, GroupPermissionDto dto) {
        if (dto.getResourceId() == null) {
            return;
        }
        ComponentMapper componentMapper = (ComponentMapper)dbSession.getMapper(ComponentMapper.class);
        Preconditions.checkArgument((componentMapper.countComponentByOrganizationAndId(dto.getOrganizationUuid(), dto.getResourceId()) == 1 ? 1 : 0) != 0, (String)"Can't insert permission '%s' for component with id '%s' in organization with uuid '%s' because this component does not belong to organization with uuid '%s'", (Object[])new Object[]{dto.getRole(), dto.getResourceId(), dto.getOrganizationUuid(), dto.getOrganizationUuid()});
    }

    private static void ensureGroupPermissionConsistency(DbSession dbSession, GroupPermissionDto dto) {
        if (dto.getGroupId() == null) {
            return;
        }
        GroupMapper groupMapper = (GroupMapper)dbSession.getMapper(GroupMapper.class);
        Preconditions.checkArgument((groupMapper.countGroupByOrganizationAndId(dto.getOrganizationUuid(), dto.getGroupId()) == 1 ? 1 : 0) != 0, (String)"Can't insert permission '%s' for group with id '%s' in organization with uuid '%s' because this group does not belong to organization with uuid '%s'", (Object[])new Object[]{dto.getRole(), dto.getGroupId(), dto.getOrganizationUuid(), dto.getOrganizationUuid()});
    }

    public void deleteByRootComponentId(DbSession dbSession, long rootComponentId) {
        GroupPermissionDao.mapper(dbSession).deleteByRootComponentId(rootComponentId);
    }

    public int deleteByRootComponentIdAndGroupId(DbSession dbSession, long rootComponentId, @Nullable Integer groupId) {
        return GroupPermissionDao.mapper(dbSession).deleteByRootComponentIdAndGroupId(rootComponentId, groupId);
    }

    public int deleteByRootComponentIdAndPermission(DbSession dbSession, long rootComponentId, String permission) {
        return GroupPermissionDao.mapper(dbSession).deleteByRootComponentIdAndPermission(rootComponentId, permission);
    }

    public void delete(DbSession dbSession, String permission, String organizationUuid, @Nullable Integer groupId, @Nullable Long rootComponentId) {
        GroupPermissionDao.mapper(dbSession).delete(permission, organizationUuid, groupId, rootComponentId);
    }

    public void deleteByOrganization(DbSession dbSession, String organizationUuid) {
        GroupPermissionDao.mapper(dbSession).deleteByOrganization(organizationUuid);
    }

    private static GroupPermissionMapper mapper(DbSession session) {
        return (GroupPermissionMapper)session.getMapper(GroupPermissionMapper.class);
    }
}

