/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.permission.template;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicMapper;

public class PermissionTemplateCharacteristicDao
implements Dao {
    public List<PermissionTemplateCharacteristicDto> selectByTemplateIds(DbSession dbSession, List<Long> templateIds) {
        return DatabaseUtils.executeLargeInputs(templateIds, partitionOfTemplateIds -> PermissionTemplateCharacteristicDao.mapper(dbSession).selectByTemplateIds((List<Long>)partitionOfTemplateIds));
    }

    public Optional<PermissionTemplateCharacteristicDto> selectByPermissionAndTemplateId(DbSession dbSession, String permission, long templateId) {
        PermissionTemplateCharacteristicDto dto = PermissionTemplateCharacteristicDao.mapper(dbSession).selectByPermissionAndTemplateId(permission, templateId);
        return Optional.ofNullable(dto);
    }

    public PermissionTemplateCharacteristicDto insert(DbSession dbSession, PermissionTemplateCharacteristicDto dto) {
        Preconditions.checkArgument((dto.getCreatedAt() != 0L && dto.getUpdatedAt() != 0L ? 1 : 0) != 0);
        PermissionTemplateCharacteristicDao.mapper(dbSession).insert(dto);
        return dto;
    }

    public PermissionTemplateCharacteristicDto update(DbSession dbSession, PermissionTemplateCharacteristicDto templatePermissionDto) {
        Objects.requireNonNull(templatePermissionDto.getId());
        PermissionTemplateCharacteristicDao.mapper(dbSession).update(templatePermissionDto);
        return templatePermissionDto;
    }

    private static PermissionTemplateCharacteristicMapper mapper(DbSession dbSession) {
        return (PermissionTemplateCharacteristicMapper)dbSession.getMapper(PermissionTemplateCharacteristicMapper.class);
    }
}

