/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.purge;

import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.sonar.db.purge.IdUuidPair;
import org.sonar.db.purge.PurgeSnapshotQuery;
import org.sonar.db.purge.PurgeableAnalysisDto;

public interface PurgeMapper {
    public List<IdUuidPair> selectAnalysisIdsAndUuids(PurgeSnapshotQuery var1);

    public List<IdUuidPair> selectRootAndModulesOrSubviewsByProjectUuid(@Param(value="rootUuid") String var1);

    public Set<String> selectDisabledComponentsWithFileSource(@Param(value="projectUuid") String var1);

    public Set<String> selectDisabledComponentsWithUnresolvedIssues(@Param(value="projectUuid") String var1);

    public Set<String> selectDisabledComponentsWithLiveMeasures(@Param(value="projectUuid") String var1);

    public void deleteAnalyses(@Param(value="analysisUuids") List<String> var1);

    public void deleteAnalysisProperties(@Param(value="analysisUuids") List<String> var1);

    public void deleteAnalysisDuplications(@Param(value="analysisUuids") List<String> var1);

    public void deleteAnalysisEvents(@Param(value="analysisUuids") List<String> var1);

    public void deleteAnalysisEventComponentChanges(@Param(value="analysisUuids") List<String> var1);

    public void deleteAnalysisMeasures(@Param(value="analysisUuids") List<String> var1);

    public void fullDeleteComponentMeasures(@Param(value="componentUuids") List<String> var1);

    public void deleteComponentMeasures(@Param(value="analysisUuids") List<String> var1, @Param(value="componentUuids") List<String> var2);

    public List<Long> selectMetricIdsWithoutHistoricalData();

    public void deleteAnalysisWastedMeasures(@Param(value="analysisUuids") List<String> var1, @Param(value="metricIds") List<Long> var2);

    public void updatePurgeStatusToOne(@Param(value="analysisUuids") List<String> var1);

    public void resolveComponentIssuesNotAlreadyResolved(@Param(value="componentUuids") List<String> var1, @Param(value="dateAsLong") Long var2);

    public void deleteProjectLinksByProjectUuid(@Param(value="rootUuid") String var1);

    public void deletePropertiesByComponentIds(@Param(value="componentIds") List<Long> var1);

    public void deleteComponentsByProjectUuid(@Param(value="rootUuid") String var1);

    public void deleteComponentsByUuids(@Param(value="componentUuids") List<String> var1);

    public void deleteGroupRolesByComponentId(@Param(value="rootId") long var1);

    public void deleteUserRolesByComponentId(@Param(value="rootId") long var1);

    public void deleteManualMeasuresByComponentUuids(@Param(value="componentUuids") List<String> var1);

    public void deleteEventsByComponentUuid(@Param(value="componentUuid") String var1);

    public void deleteEventComponentChangesByComponentUuid(@Param(value="componentUuid") String var1);

    public List<PurgeableAnalysisDto> selectPurgeableAnalysesWithEvents(@Param(value="componentUuid") String var1);

    public List<PurgeableAnalysisDto> selectPurgeableAnalysesWithoutEvents(@Param(value="componentUuid") String var1);

    public void deleteIssueChangesByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteIssuesByProjectUuid(@Param(value="projectUuid") String var1);

    public List<String> selectOldClosedIssueKeys(@Param(value="projectUuid") String var1, @Nullable @Param(value="toDate") Long var2);

    public List<String> selectStaleShortLivingBranchesAndPullRequests(@Param(value="projectUuid") String var1, @Param(value="toDate") Long var2);

    @CheckForNull
    public String selectManualBaseline(@Param(value="projectUuid") String var1);

    public List<IdUuidPair> selectDisabledComponentsWithoutIssues(@Param(value="projectUuid") String var1);

    public void deleteIssuesFromKeys(@Param(value="keys") List<String> var1);

    public void deleteIssueChangesFromIssueKeys(@Param(value="issueKeys") List<String> var1);

    public void deleteFileSourcesByProjectUuid(String var1);

    public void deleteFileSourcesByFileUuid(@Param(value="fileUuids") List<String> var1);

    public void deleteCeTaskCharacteristicsOfCeActivityByRootUuidOrBefore(@Nullable @Param(value="rootUuid") String var1, @Nullable @Param(value="createdAtBefore") Long var2);

    public void deleteCeTaskInputOfCeActivityByRootUuidOrBefore(@Nullable @Param(value="rootUuid") String var1, @Nullable @Param(value="createdAtBefore") Long var2);

    public void deleteCeScannerContextOfCeActivityByRootUuidOrBefore(@Nullable @Param(value="rootUuid") String var1, @Nullable @Param(value="createdAtBefore") Long var2);

    public void deleteCeTaskMessageOfCeActivityByRootUuidOrBefore(@Nullable @Param(value="rootUuid") String var1, @Nullable @Param(value="createdAtBefore") Long var2);

    public void deleteCeActivityByRootUuidOrBefore(@Nullable @Param(value="rootUuid") String var1, @Nullable @Param(value="createdAtBefore") Long var2);

    public void deleteCeScannerContextOfCeQueueByRootUuid(@Param(value="rootUuid") String var1);

    public void deleteCeTaskCharacteristicsOfCeQueueByRootUuid(@Param(value="rootUuid") String var1);

    public void deleteCeTaskInputOfCeQueueByRootUuid(@Param(value="rootUuid") String var1);

    public void deleteCeTaskMessageOfCeQueueByRootUuid(@Param(value="rootUuid") String var1);

    public void deleteCeQueueByRootUuid(@Param(value="rootUuid") String var1);

    public void deleteWebhooksByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteWebhookDeliveriesByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteProjectMappingsByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteProjectAlmBindingsByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteBranchByUuid(@Param(value="uuid") String var1);

    public void deleteLiveMeasuresByProjectUuid(@Param(value="projectUuid") String var1);

    public void deleteLiveMeasuresByComponentUuids(@Param(value="componentUuids") List<String> var1);
}

