/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.db.qualityprofile;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.Dao;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.GroupMembershipDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.qualityprofile.QProfileEditGroupsDto;
import org.sonar.db.qualityprofile.QProfileEditGroupsMapper;
import org.sonar.db.qualityprofile.SearchGroupsQuery;
import org.sonar.db.user.GroupDto;

public class QProfileEditGroupsDao
implements Dao {
    private final System2 system2;

    public QProfileEditGroupsDao(System2 system2) {
        this.system2 = system2;
    }

    public boolean exists(DbSession dbSession, QProfileDto profile, GroupDto group) {
        return this.exists(dbSession, profile, Collections.singletonList(group));
    }

    public boolean exists(DbSession dbSession, QProfileDto profile, Collection<GroupDto> groups) {
        return !DatabaseUtils.executeLargeInputs((Collection)((Collection)groups.stream().map(GroupDto::getId).collect(MoreCollectors.toList())), partition -> QProfileEditGroupsDao.mapper(dbSession).selectByQProfileAndGroups(profile.getKee(), (List<Integer>)partition)).isEmpty();
    }

    public int countByQuery(DbSession dbSession, SearchGroupsQuery query) {
        return QProfileEditGroupsDao.mapper(dbSession).countByQuery(query);
    }

    public List<GroupMembershipDto> selectByQuery(DbSession dbSession, SearchGroupsQuery query, Pagination pagination) {
        return QProfileEditGroupsDao.mapper(dbSession).selectByQuery(query, pagination);
    }

    public List<String> selectQProfileUuidsByOrganizationAndGroups(DbSession dbSession, OrganizationDto organization, Collection<GroupDto> groups) {
        return DatabaseUtils.executeLargeInputs((Collection)((Collection)groups.stream().map(GroupDto::getId).collect(MoreCollectors.toList())), g -> QProfileEditGroupsDao.mapper(dbSession).selectQProfileUuidsByOrganizationAndGroups(organization.getUuid(), (List<Integer>)g));
    }

    public void insert(DbSession dbSession, QProfileEditGroupsDto dto) {
        QProfileEditGroupsDao.mapper(dbSession).insert(dto, this.system2.now());
    }

    public void deleteByQProfileAndGroup(DbSession dbSession, QProfileDto profile, GroupDto group) {
        QProfileEditGroupsDao.mapper(dbSession).delete(profile.getKee(), group.getId());
    }

    public void deleteByQProfiles(DbSession dbSession, List<QProfileDto> qProfiles) {
        DatabaseUtils.executeLargeUpdates((Collection)((Collection)qProfiles.stream().map(QProfileDto::getKee).collect(MoreCollectors.toList())), p -> QProfileEditGroupsDao.mapper(dbSession).deleteByQProfiles((Collection<String>)p));
    }

    public void deleteByGroup(DbSession dbSession, GroupDto group) {
        QProfileEditGroupsDao.mapper(dbSession).deleteByGroup(group.getId());
    }

    private static QProfileEditGroupsMapper mapper(DbSession dbSession) {
        return (QProfileEditGroupsMapper)dbSession.getMapper(QProfileEditGroupsMapper.class);
    }
}

