/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.ce.task.projectanalysis.component.ComponentUuidFactory;
import org.sonar.core.util.Uuids;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentWithModuleUuidDto;

public class ComponentUuidFactoryWithMigration
implements ComponentUuidFactory {
    private final Map<String, String> uuidsByDbKey = new HashMap<String, String>();
    private final Map<String, String> uuidsByMigratedKey = new HashMap<String, String>();

    public ComponentUuidFactoryWithMigration(DbClient dbClient, DbSession dbSession, String rootKey, Function<String, String> pathToKey, Map<String, String> reportModulesPath) {
        Map<String, String> modulePathsByUuid;
        List keys = dbClient.componentDao().selectUuidsByKeyFromProjectKey(dbSession, rootKey);
        keys.forEach(dto -> this.uuidsByDbKey.put(dto.key(), dto.uuid()));
        if (!reportModulesPath.isEmpty() && !(modulePathsByUuid = ComponentUuidFactoryWithMigration.loadModulePathsByUuid(dbClient, dbSession, rootKey, reportModulesPath)).isEmpty()) {
            this.doMigration(dbClient, dbSession, rootKey, pathToKey, modulePathsByUuid);
        }
    }

    private void doMigration(DbClient dbClient, DbSession dbSession, String rootKey, Function<String, String> pathToKey, Map<String, String> modulePathsByUuid) {
        List<ComponentWithModuleUuidDto> dtos = ComponentUuidFactoryWithMigration.loadComponentsWithModuleUuid(dbClient, dbSession, rootKey);
        for (ComponentWithModuleUuidDto dto : dtos) {
            String modulePathFromRootProject;
            if ("/".equals(dto.path())) continue;
            if ("PRJ".equals(dto.scope())) {
                modulePathFromRootProject = modulePathsByUuid.get(dto.uuid());
                if (modulePathFromRootProject == null && !StringUtils.isEmpty((String)dto.moduleUuid())) continue;
                pathToKey.apply(modulePathFromRootProject);
                this.uuidsByMigratedKey.put(pathToKey.apply(modulePathFromRootProject), dto.uuid());
                continue;
            }
            modulePathFromRootProject = modulePathsByUuid.get(dto.moduleUuid());
            String componentPath = ComponentUuidFactoryWithMigration.createComponentPath(dto, modulePathFromRootProject);
            this.uuidsByMigratedKey.put(pathToKey.apply(componentPath), dto.uuid());
        }
    }

    @CheckForNull
    private static String createComponentPath(ComponentWithModuleUuidDto dto, @Nullable String modulePathFromRootProject) {
        if (StringUtils.isEmpty((String)modulePathFromRootProject)) {
            return dto.path();
        }
        if (StringUtils.isEmpty((String)dto.path())) {
            return modulePathFromRootProject;
        }
        return modulePathFromRootProject + "/" + dto.path();
    }

    private static List<ComponentWithModuleUuidDto> loadComponentsWithModuleUuid(DbClient dbClient, DbSession dbSession, String rootKey) {
        return dbClient.componentDao().selectEnabledComponentsWithModuleUuidFromProjectKey(dbSession, rootKey);
    }

    private static Map<String, String> loadModulePathsByUuid(DbClient dbClient, DbSession dbSession, String rootKey, Map<String, String> pathByModuleKey) {
        List moduleDtos = dbClient.componentDao().selectProjectAndModulesFromProjectKey(dbSession, rootKey, true).stream().filter(c -> "BRC".equals(c.qualifier())).collect(Collectors.toList());
        if (moduleDtos.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> modulePathByUuid = new HashMap<String, String>();
        for (ComponentDto dto : moduleDtos) {
            String relativePath = pathByModuleKey.get(dto.getKey());
            if (relativePath == null) continue;
            modulePathByUuid.put(dto.uuid(), relativePath);
        }
        return modulePathByUuid;
    }

    @Override
    public String getOrCreateForKey(String key) {
        return this.uuidsByDbKey.computeIfAbsent(key, k1 -> this.uuidsByMigratedKey.computeIfAbsent((String)k1, k2 -> Uuids.create()));
    }
}

