/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.formula.coverage;

import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.formula.Counter;
import org.sonar.ce.task.projectanalysis.formula.CounterInitializationContext;

public abstract class ElementsAndCoveredElementsCounter
implements Counter<ElementsAndCoveredElementsCounter> {
    protected long elements = 0L;
    protected long coveredElements = 0L;

    @Override
    public void aggregate(ElementsAndCoveredElementsCounter counter) {
        this.elements += counter.elements;
        this.coveredElements += counter.coveredElements;
    }

    @Override
    public void initialize(CounterInitializationContext context) {
        Component component = context.getLeaf();
        if (component.getType() == Component.Type.FILE && component.getFileAttributes().isUnitTest()) {
            return;
        }
        this.initializeForSupportedLeaf(context);
    }

    protected abstract void initializeForSupportedLeaf(CounterInitializationContext var1);
}

