/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.MergeAndTargetBranchComponentUuids;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.issue.IssueCache;
import org.sonar.ce.task.projectanalysis.issue.IssueLifecycle;
import org.sonar.ce.task.projectanalysis.issue.IssueTrackingDelegator;
import org.sonar.ce.task.projectanalysis.issue.IssueVisitors;
import org.sonar.ce.task.projectanalysis.issue.SiblingsIssueMerger;
import org.sonar.ce.task.projectanalysis.issue.TrackingResult;
import org.sonar.ce.task.projectanalysis.util.cache.DiskCache;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;

public class IntegrateIssuesVisitor
extends TypeAwareVisitorAdapter {
    private final IssueCache issueCache;
    private final IssueLifecycle issueLifecycle;
    private final IssueVisitors issueVisitors;
    private final IssueTrackingDelegator issueTracking;
    private final SiblingsIssueMerger issueStatusCopier;
    private final MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids;

    public IntegrateIssuesVisitor(IssueCache issueCache, IssueLifecycle issueLifecycle, IssueVisitors issueVisitors, IssueTrackingDelegator issueTracking, SiblingsIssueMerger issueStatusCopier, MergeAndTargetBranchComponentUuids mergeAndTargetBranchComponentUuids) {
        super(CrawlerDepthLimit.FILE, ComponentVisitor.Order.POST_ORDER);
        this.issueCache = issueCache;
        this.issueLifecycle = issueLifecycle;
        this.issueVisitors = issueVisitors;
        this.issueTracking = issueTracking;
        this.issueStatusCopier = issueStatusCopier;
        this.mergeAndTargetBranchComponentUuids = mergeAndTargetBranchComponentUuids;
    }

    @Override
    public void visitAny(Component component) {
        try (DiskCache.DiskAppender cacheAppender = this.issueCache.newAppender();){
            this.issueVisitors.beforeComponent(component);
            TrackingResult tracking = this.issueTracking.track(component);
            this.fillNewOpenIssues(component, tracking.newIssues(), cacheAppender);
            this.fillExistingOpenIssues(component, tracking.issuesToMerge(), cacheAppender);
            this.closeIssues(component, tracking.issuesToClose(), cacheAppender);
            this.copyIssues(component, tracking.issuesToCopy(), cacheAppender);
            this.issueVisitors.afterComponent(component);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to process issues of component '%s'", component.getDbKey()), e);
        }
    }

    private void fillNewOpenIssues(Component component, Stream<DefaultIssue> newIssues, DiskCache.DiskAppender cacheAppender) {
        List newIssuesList = (List)newIssues.peek(this.issueLifecycle::initNewOpenIssue).collect(MoreCollectors.toList());
        if (newIssuesList.isEmpty()) {
            return;
        }
        this.issueStatusCopier.tryMerge(component, newIssuesList);
        for (DefaultIssue issue : newIssuesList) {
            this.process(component, issue, cacheAppender);
        }
    }

    private void copyIssues(Component component, Map<DefaultIssue, DefaultIssue> matched, DiskCache.DiskAppender cacheAppender) {
        for (Map.Entry<DefaultIssue, DefaultIssue> entry : matched.entrySet()) {
            DefaultIssue raw = entry.getKey();
            DefaultIssue base = entry.getValue();
            this.issueLifecycle.copyExistingOpenIssueFromLongLivingBranch(raw, base, this.mergeAndTargetBranchComponentUuids.getMergeBranchName());
            this.process(component, raw, cacheAppender);
        }
    }

    private void fillExistingOpenIssues(Component component, Map<DefaultIssue, DefaultIssue> matched, DiskCache.DiskAppender cacheAppender) {
        for (Map.Entry<DefaultIssue, DefaultIssue> entry : matched.entrySet()) {
            DefaultIssue raw = entry.getKey();
            DefaultIssue base = entry.getValue();
            this.issueLifecycle.mergeExistingOpenIssue(raw, base);
            this.process(component, raw, cacheAppender);
        }
    }

    private void closeIssues(Component component, Stream<DefaultIssue> issues, DiskCache.DiskAppender cacheAppender) {
        issues.forEach(issue -> {
            issue.setBeingClosed(true);
            this.process(component, (DefaultIssue)issue, cacheAppender);
        });
    }

    private void process(Component component, DefaultIssue issue, DiskCache.DiskAppender cacheAppender) {
        this.issueLifecycle.doAutomaticTransition(issue);
        this.issueVisitors.onIssue(component, issue);
        cacheAppender.append(issue);
    }
}

