/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.issue.commonrule;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRule;
import org.sonar.ce.task.projectanalysis.qualityprofile.ActiveRulesHolder;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.server.rule.CommonRuleKeys;

public abstract class CommonRule {
    private final ActiveRulesHolder activeRulesHolder;
    private final String key;

    public CommonRule(ActiveRulesHolder activeRulesHolder, String key) {
        this.activeRulesHolder = activeRulesHolder;
        this.key = key;
    }

    @CheckForNull
    public DefaultIssue processFile(Component file, String fileLanguage) {
        CommonRuleIssue cri;
        DefaultIssue issue = null;
        RuleKey ruleKey = RuleKey.of((String)CommonRuleKeys.commonRepositoryForLang((String)fileLanguage), (String)this.key);
        Optional<ActiveRule> activeRule = this.activeRulesHolder.get(ruleKey);
        if (activeRule.isPresent() && (cri = this.doProcessFile(file, activeRule.get())) != null) {
            issue = new DefaultIssue();
            issue.setGap(Double.valueOf(cri.effortToFix));
            issue.setMessage(cri.message);
            issue.setRuleKey(ruleKey);
            issue.setSeverity(activeRule.get().getSeverity());
            issue.setLine(null);
            issue.setChecksum("");
            issue.setIsFromExternalRuleEngine(false);
        }
        return issue;
    }

    @CheckForNull
    protected abstract CommonRuleIssue doProcessFile(Component var1, ActiveRule var2);

    protected static double getMinDensityParam(ActiveRule activeRule, String paramKey) {
        String s = activeRule.getParams().get(paramKey);
        if (StringUtils.isNotBlank((String)s)) {
            double d = Double.parseDouble(s);
            if (d < 0.0 || d > 100.0) {
                throw new IllegalStateException(String.format("Minimum density of rule [%s] is incorrect. Got [%s] but must be between 0 and 100.", activeRule.getRuleKey(), s));
            }
            return d;
        }
        throw new IllegalStateException(String.format("Required parameter [%s] is missing on rule [%s]", paramKey, activeRule.getRuleKey()));
    }

    protected static class CommonRuleIssue {
        private final double effortToFix;
        private final String message;

        public CommonRuleIssue(double effortToFix, String message) {
            this.effortToFix = effortToFix;
            this.message = message;
        }
    }
}

