/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.scm;

import java.util.Optional;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.MergeAndTargetBranchComponentUuids;
import org.sonar.ce.task.projectanalysis.filemove.MovedFilesRepository;
import org.sonar.ce.task.projectanalysis.scm.DbScmInfo;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.source.FileSourceDto;

public class ScmInfoDbLoader {
    private static final Logger LOGGER = Loggers.get(ScmInfoDbLoader.class);
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final MovedFilesRepository movedFilesRepository;
    private final DbClient dbClient;
    private final MergeAndTargetBranchComponentUuids mergeBranchComponentUuid;

    public ScmInfoDbLoader(AnalysisMetadataHolder analysisMetadataHolder, MovedFilesRepository movedFilesRepository, DbClient dbClient, MergeAndTargetBranchComponentUuids mergeBranchComponentUuid) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.movedFilesRepository = movedFilesRepository;
        this.dbClient = dbClient;
        this.mergeBranchComponentUuid = mergeBranchComponentUuid;
    }

    public Optional<DbScmInfo> getScmInfo(Component file) {
        Optional<String> uuid = this.getFileUUid(file);
        if (!uuid.isPresent()) {
            return Optional.empty();
        }
        LOGGER.trace("Reading SCM info from DB for file '{}'", (Object)uuid.get());
        try (DbSession dbSession = this.dbClient.openSession(false);){
            FileSourceDto dto = this.dbClient.fileSourceDao().selectByFileUuid(dbSession, uuid.get());
            if (dto == null) {
                Optional<DbScmInfo> optional = Optional.empty();
                return optional;
            }
            Optional<DbScmInfo> optional = DbScmInfo.create(dto.getSourceData().getLinesList(), dto.getSrcHash());
            return optional;
        }
    }

    private Optional<String> getFileUUid(Component file) {
        if (!this.analysisMetadataHolder.isFirstAnalysis() && !this.analysisMetadataHolder.isSLBorPR()) {
            Optional<MovedFilesRepository.OriginalFile> originalFile = this.movedFilesRepository.getOriginalFile(file);
            if (originalFile.isPresent()) {
                return originalFile.map(MovedFilesRepository.OriginalFile::getUuid);
            }
            return Optional.of(file.getUuid());
        }
        Branch branch = this.analysisMetadataHolder.getBranch();
        if (!branch.isMain()) {
            String uuid = this.mergeBranchComponentUuid.getTargetBranchComponentUuid(file.getDbKey());
            if (uuid == null) {
                uuid = this.mergeBranchComponentUuid.getMergeBranchComponentUuid(file.getDbKey());
            }
            return Optional.ofNullable(uuid);
        }
        return Optional.empty();
    }
}

