/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.step;

import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.sonar.ce.task.projectanalysis.component.Component;
import org.sonar.ce.task.projectanalysis.component.ComponentVisitor;
import org.sonar.ce.task.projectanalysis.component.CrawlerDepthLimit;
import org.sonar.ce.task.projectanalysis.component.DepthTraversalTypeAwareCrawler;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.ce.task.projectanalysis.component.TypeAwareVisitorAdapter;
import org.sonar.ce.task.projectanalysis.measure.Measure;
import org.sonar.ce.task.projectanalysis.measure.MeasureRepository;
import org.sonar.ce.task.projectanalysis.measure.MeasureToMeasureDto;
import org.sonar.ce.task.projectanalysis.metric.Metric;
import org.sonar.ce.task.projectanalysis.metric.MetricRepository;
import org.sonar.ce.task.step.ComputationStep;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.measure.MeasureDao;
import org.sonar.db.measure.MeasureDto;

public class PersistMeasuresStep
implements ComputationStep {
    private final DbClient dbClient;
    private final MetricRepository metricRepository;
    private final MeasureToMeasureDto measureToMeasureDto;
    private final TreeRootHolder treeRootHolder;
    private final MeasureRepository measureRepository;

    public PersistMeasuresStep(DbClient dbClient, MetricRepository metricRepository, MeasureToMeasureDto measureToMeasureDto, TreeRootHolder treeRootHolder, MeasureRepository measureRepository) {
        this.dbClient = dbClient;
        this.metricRepository = metricRepository;
        this.measureToMeasureDto = measureToMeasureDto;
        this.treeRootHolder = treeRootHolder;
        this.measureRepository = measureRepository;
    }

    public String getDescription() {
        return "Persist measures";
    }

    public void execute(ComputationStep.Context context) {
        try (DbSession dbSession = this.dbClient.openSession(true);){
            MeasureVisitor visitor = new MeasureVisitor(dbSession);
            new DepthTraversalTypeAwareCrawler(visitor).visit(this.treeRootHolder.getRoot());
            dbSession.commit();
            context.getStatistics().add("inserts", (Object)visitor.inserts);
        }
    }

    private static enum NonEmptyMeasure implements Predicate<Measure>
    {
        INSTANCE;


        @Override
        public boolean test(@Nonnull Measure input) {
            return input.getValueType() != Measure.ValueType.NO_VALUE || input.hasVariation() || input.getData() != null;
        }
    }

    private class MeasureVisitor
    extends TypeAwareVisitorAdapter {
        private final DbSession session;
        private int inserts;

        private MeasureVisitor(DbSession session) {
            super(CrawlerDepthLimit.LEAVES, ComponentVisitor.Order.PRE_ORDER);
            this.inserts = 0;
            this.session = session;
        }

        @Override
        public void visitProject(Component project) {
            this.persistMeasures(project);
        }

        @Override
        public void visitDirectory(Component directory) {
        }

        @Override
        public void visitView(Component view) {
            this.persistMeasures(view);
        }

        @Override
        public void visitSubView(Component subView) {
            this.persistMeasures(subView);
        }

        @Override
        public void visitProjectView(Component projectView) {
        }

        private void persistMeasures(Component component) {
            SetMultimap<String, Measure> measures = PersistMeasuresStep.this.measureRepository.getRawMeasures(component);
            for (Map.Entry measuresByMetricKey : measures.asMap().entrySet()) {
                String metricKey = (String)measuresByMetricKey.getKey();
                Metric metric = PersistMeasuresStep.this.metricRepository.getByKey(metricKey);
                MeasureDao measureDao = PersistMeasuresStep.this.dbClient.measureDao();
                ((Collection)measuresByMetricKey.getValue()).stream().filter(NonEmptyMeasure.INSTANCE).forEach(measure -> {
                    MeasureDto measureDto = PersistMeasuresStep.this.measureToMeasureDto.toMeasureDto((Measure)measure, metric, component);
                    measureDao.insert(this.session, measureDto);
                    ++this.inserts;
                });
            }
        }
    }
}

